/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.proto.CollectionProto;
import ch.epfl.dedis.proto.OmniLedgerProto;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Proof {
    private OmniLedgerProto.Proof proof;
    private CollectionProto.Dump leaf;

    public Proof(OmniLedgerProto.Proof p) {
        this.proof = p;
        List<CollectionProto.Step> steps = p.getInclusionproof().getStepsList();
        CollectionProto.Dump left = steps.get(steps.size() - 1).getLeft();
        CollectionProto.Dump right = steps.get(steps.size() - 1).getRight();
        if (Arrays.equals(left.getKey().toByteArray(), this.getKey())) {
            this.leaf = left;
        } else if (Arrays.equals(right.getKey().toByteArray(), this.getKey())) {
            this.leaf = right;
        }
    }

    public boolean verify() throws CothorityException {
        return false;
    }

    public boolean matches() {
        return this.leaf != null;
    }

    public byte[] getKey() {
        return this.proof.getInclusionproof().getKey().toByteArray();
    }

    public List<byte[]> getValues() {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (ByteString v : this.leaf.getValuesList()) {
            ret.add(v.toByteArray());
        }
        return ret;
    }
}

