/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.HashId;
import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import java.security.SecureRandom;
import java.util.Arrays;

public class SubId
implements HashId {
    private final byte[] id;
    public static final int length = 32;

    public SubId(byte[] id) throws CothorityCryptoException {
        if (id.length != 32) {
            throw new CothorityCryptoException("need 32 bytes for subId, only got " + id.length);
        }
        this.id = Arrays.copyOf(id, id.length);
    }

    @Override
    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.id, ((SubId)o).id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public String toString() {
        return Hex.printHexBinary(this.id);
    }

    public static SubId zero() throws CothorityCryptoException {
        return new SubId(new byte[32]);
    }

    public static SubId one() throws CothorityCryptoException {
        byte[] buf = new byte[32];
        buf[31] = 1;
        return new SubId(buf);
    }

    public static SubId random() throws CothorityCryptoException {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return new SubId(bytes);
    }
}

