/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger;

import ch.epfl.dedis.lib.HashId;
import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.SubId;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import com.google.protobuf.ByteString;
import java.util.Arrays;

public class TransactionId
implements HashId {
    private final byte[] id;
    public static final int length = 64;

    public TransactionId(byte[] id) throws CothorityCryptoException {
        if (id.length != 64) {
            throw new CothorityCryptoException("need 64 bytes for instanceID, only got " + id.length);
        }
        this.id = Arrays.copyOf(id, id.length);
    }

    public TransactionId(DarcId did, SubId sid) {
        this.id = new byte[64];
        System.arraycopy(did.getId(), 0, this.id, 0, 32);
        System.arraycopy(sid.getId(), 0, this.id, 32, 32);
    }

    @Override
    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public DarcId getDarcId() throws CothorityCryptoException {
        return new DarcId(Arrays.copyOf(this.id, 32));
    }

    public SubId getSubId() throws CothorityCryptoException {
        return new SubId(Arrays.copyOfRange(this.id, 32, 64));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.id, ((TransactionId)o).id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public String toString() {
        return Hex.printHexBinary(this.id);
    }

    public ByteString toProto() {
        return ByteString.copyFrom((byte[])this.id);
    }
}

