/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.contracts;

import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.omniledger.Argument;
import ch.epfl.dedis.lib.omniledger.ClientTransaction;
import ch.epfl.dedis.lib.omniledger.Instance;
import ch.epfl.dedis.lib.omniledger.InstanceId;
import ch.epfl.dedis.lib.omniledger.Instruction;
import ch.epfl.dedis.lib.omniledger.Invoke;
import ch.epfl.dedis.lib.omniledger.OmniledgerRPC;
import ch.epfl.dedis.lib.omniledger.Proof;
import ch.epfl.dedis.lib.omniledger.Spawn;
import ch.epfl.dedis.lib.omniledger.SubId;
import ch.epfl.dedis.lib.omniledger.TransactionId;
import ch.epfl.dedis.lib.omniledger.darc.Darc;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import ch.epfl.dedis.lib.omniledger.darc.Request;
import ch.epfl.dedis.lib.omniledger.darc.Signature;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarcInstance {
    private Instance instance;
    private Darc darc;
    private OmniledgerRPC ol;
    private static final Logger logger = LoggerFactory.getLogger(DarcInstance.class);

    public DarcInstance(OmniledgerRPC ol, InstanceId id) throws CothorityException {
        this.ol = ol;
        Proof p = ol.getProof(id);
        this.instance = new Instance(p);
        if (!this.instance.getContractId().equals("darc")) {
            logger.error("wrong instance: {}", (Object)this.instance.getContractId());
            throw new CothorityNotFoundException("this is not a darc instance");
        }
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public DarcInstance(OmniledgerRPC ol, Darc d) throws CothorityException {
        this(ol, new InstanceId(d.getBaseId(), SubId.zero()));
    }

    public void update() throws CothorityException {
        this.instance = new Instance(this.ol.getProof(this.instance.getId()));
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public Instruction evolveDarcInstruction(Darc newDarc, Signer owner, int pos, int len) throws CothorityCryptoException {
        newDarc.increaseVersion();
        newDarc.setPrevId(this.darc);
        newDarc.setBaseId(this.darc.getBaseId());
        if (!newDarc.getBaseId().equals(this.darc.getBaseId()) || newDarc.getVersion() != this.darc.getVersion() + 1L) {
            throw new CothorityCryptoException("not correct darc to evolve");
        }
        Invoke inv = new Invoke("evolve", "darc", newDarc.toProto().toByteArray());
        Instruction inst = new Instruction(new InstanceId(this.darc.getBaseId(), SubId.zero()), SubId.zero().getId(), pos, len, inv);
        try {
            Request r = new Request(this.darc.getBaseId(), "invoke:evolve", inst.hash(), Arrays.asList(owner.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(owner.sign(r.hash()), owner.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public TransactionId evolveDarc(Darc newDarc, Signer owner) throws CothorityException {
        Instruction inst = this.evolveDarcInstruction(newDarc, owner, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.ol.sendTransaction(ct);
        return new TransactionId(this.darc.getBaseId(), SubId.zero());
    }

    public void evolveDarcAndWait(Darc newDarc, Signer owner) throws CothorityException {
        this.evolveDarc(newDarc, owner);
        for (int i = 0; i < 10; ++i) {
            Proof p = this.ol.getProof(this.instance.getId());
            Instance inst = new Instance(p);
            try {
                this.darc = new Darc(inst.getData());
                if (this.darc.getVersion() == newDarc.getVersion()) {
                    return;
                }
                Thread.sleep(this.ol.getConfig().getBlockInterval().toMillis());
                continue;
            }
            catch (InvalidProtocolBufferException e) {
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new CothorityCommunicationException("didn't find new darc");
    }

    public Instruction spawnContractInstruction(String contractID, Signer s, List<Argument> args, int pos, int len) throws CothorityCryptoException {
        Spawn sp = new Spawn(contractID, args);
        Instruction inst = new Instruction(new InstanceId(this.darc.getBaseId(), SubId.zero()), SubId.random().getId(), pos, len, sp);
        try {
            Request r = new Request(this.darc.getBaseId(), "spawn:" + contractID, inst.hash(), Arrays.asList(s.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(s.sign(r.hash()), s.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public TransactionId spawnContract(String contractID, Signer s, List<Argument> args) throws CothorityException {
        Instruction inst = this.spawnContractInstruction(contractID, s, args, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.ol.sendTransaction(ct);
        return new TransactionId(this.darc.getBaseId(), new SubId(inst.hash()));
    }

    public Proof spawnContractAndWait(String contractID, Signer s, List<Argument> args, int wait) throws CothorityException {
        Instruction inst = this.spawnContractInstruction(contractID, s, args, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.ol.sendTransactionAndWait(ct, wait);
        InstanceId iid = inst.deriveId(contractID);
        if (contractID.equals("darc")) {
            try {
                Darc d = new Darc(args.get(0).getValue());
                iid = new InstanceId(d.getBaseId(), SubId.zero());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CothorityCommunicationException("this is not a correct darc-spawn");
            }
        }
        return this.ol.getProof(iid);
    }

    public DarcId getId() throws CothorityCryptoException {
        return this.darc.getId();
    }

    public Darc getDarc() throws CothorityCryptoException {
        return this.darc.copy();
    }

    public Instance getInstance() {
        return this.instance;
    }
}

