/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.contracts;

import ch.epfl.dedis.lib.eventlog.Event;
import ch.epfl.dedis.lib.eventlog.SearchResponse;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.omniledger.Argument;
import ch.epfl.dedis.lib.omniledger.ClientTransaction;
import ch.epfl.dedis.lib.omniledger.Instance;
import ch.epfl.dedis.lib.omniledger.InstanceId;
import ch.epfl.dedis.lib.omniledger.Instruction;
import ch.epfl.dedis.lib.omniledger.Invoke;
import ch.epfl.dedis.lib.omniledger.OmniledgerRPC;
import ch.epfl.dedis.lib.omniledger.Proof;
import ch.epfl.dedis.lib.omniledger.Spawn;
import ch.epfl.dedis.lib.omniledger.SubId;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import ch.epfl.dedis.proto.EventLogProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogInstance {
    private Instance instance;
    private OmniledgerRPC ol;
    private static final Logger logger = LoggerFactory.getLogger(EventLogInstance.class);

    public EventLogInstance(OmniledgerRPC ol, List<Signer> signers, DarcId darcId) throws CothorityException {
        this.ol = ol;
        InstanceId id = this.initEventlogInstance(signers, darcId);
        try {
            Thread.sleep(5L * ol.getConfig().getBlockInterval().toMillis());
        }
        catch (InterruptedException e) {
            throw new CothorityException(e);
        }
        this.instance = this.getInstaceProof(id);
    }

    public EventLogInstance(OmniledgerRPC ol, InstanceId id) throws CothorityException {
        this.ol = ol;
        this.instance = this.getInstaceProof(id);
    }

    public List<InstanceId> log(List<Event> events, List<Signer> signers) throws CothorityException {
        Pair<ClientTransaction, List<InstanceId>> txAndKeys = EventLogInstance.makeTx(events, this.instance.getId(), signers);
        this.ol.sendTransaction((ClientTransaction)txAndKeys._1);
        return (List)txAndKeys._2;
    }

    public InstanceId log(Event event, List<Signer> signers) throws CothorityException {
        return this.log(Arrays.asList(event), signers).get(0);
    }

    public Event get(InstanceId key) throws CothorityException {
        Proof p = this.ol.getProof(key);
        if (!p.matches()) {
            throw new CothorityCryptoException("key does not exist");
        }
        if (!Arrays.equals(p.getKey(), key.getId())) {
            throw new CothorityCryptoException("wrong key");
        }
        if (p.getValues().size() < 2) {
            throw new CothorityCryptoException("not enough values");
        }
        try {
            EventLogProto.Event event = EventLogProto.Event.parseFrom(p.getValues().get(0));
            return new Event(event);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SearchResponse search(String topic, long from, long to) throws CothorityException {
        EventLogProto.SearchRequest.Builder b = EventLogProto.SearchRequest.newBuilder();
        b.setEventlogid(this.instance.getId().toProto());
        b.setId(this.ol.getGenesis().getId().toProto());
        b.setTopic(topic);
        b.setFrom(from);
        b.setTo(to);
        ByteString msg = this.ol.getRoster().sendMessage("EventLog/SearchRequest", b.build());
        try {
            EventLogProto.SearchResponse resp = EventLogProto.SearchResponse.parseFrom(msg);
            return new SearchResponse(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public InstanceId getInstanceId() {
        return this.instance.getId();
    }

    private InstanceId initEventlogInstance(List<Signer> signers, DarcId darcId) throws CothorityException {
        if (this.instance != null) {
            throw new CothorityException("already have an instance");
        }
        Spawn spawn = new Spawn("eventlog", new ArrayList<Argument>());
        InstanceId darcInstId = new InstanceId(darcId, new SubId(new byte[32]));
        Instruction instr = new Instruction(darcInstId, EventLogInstance.genNonce(), 0, 1, spawn);
        instr.signBy(signers);
        ClientTransaction tx = new ClientTransaction(Arrays.asList(instr));
        this.ol.sendTransaction(tx);
        SubId subId = new SubId(instr.hash());
        return new InstanceId(darcId, subId);
    }

    private Instance getInstaceProof(InstanceId id) throws CothorityException {
        Proof p = this.ol.getProof(id);
        Instance inst = new Instance(p);
        if (!inst.getContractId().equals("eventlog")) {
            logger.error("wrong instance: {}", (Object)inst.getContractId());
            throw new CothorityNotFoundException("this is not an eventlog instance");
        }
        logger.info("new eventlog instance: " + inst.getId().toString());
        return inst;
    }

    private static Pair<ClientTransaction, List<InstanceId>> makeTx(List<Event> events, InstanceId instId, List<Signer> signers) throws CothorityCryptoException {
        byte[] instrNonce = EventLogInstance.genNonce();
        ArrayList<Instruction> instrs = new ArrayList<Instruction>();
        ArrayList<InstanceId> keys = new ArrayList<InstanceId>();
        int idx = 0;
        for (Event e : events) {
            ArrayList<Argument> args = new ArrayList<Argument>();
            args.add(new Argument("event", e.toProto().toByteArray()));
            Invoke invoke = new Invoke("eventlog", args);
            Instruction instr = new Instruction(instId, instrNonce, idx, events.size(), invoke);
            instr.signBy(signers);
            instrs.add(instr);
            keys.add(instr.deriveId("event"));
            ++idx;
        }
        ClientTransaction tx = new ClientTransaction(instrs);
        return new Pair<ClientTransaction, List<InstanceId>>(tx, keys);
    }

    private static byte[] genNonce() {
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[32];
        sr.nextBytes(nonce);
        return nonce;
    }

    private static final class Pair<A, B> {
        A _1;
        B _2;

        private Pair(A a, B b) {
            this._1 = a;
            this._2 = b;
        }
    }
}

