/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.contracts;

import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.omniledger.ClientTransaction;
import ch.epfl.dedis.lib.omniledger.Instance;
import ch.epfl.dedis.lib.omniledger.InstanceId;
import ch.epfl.dedis.lib.omniledger.Instruction;
import ch.epfl.dedis.lib.omniledger.Invoke;
import ch.epfl.dedis.lib.omniledger.OmniledgerRPC;
import ch.epfl.dedis.lib.omniledger.Proof;
import ch.epfl.dedis.lib.omniledger.SubId;
import ch.epfl.dedis.lib.omniledger.TransactionId;
import ch.epfl.dedis.lib.omniledger.darc.Request;
import ch.epfl.dedis.lib.omniledger.darc.Signature;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueInstance {
    private Instance instance;
    private OmniledgerRPC ol;
    private byte[] value;
    private static final Logger logger = LoggerFactory.getLogger(ValueInstance.class);

    public ValueInstance(OmniledgerRPC ol, InstanceId id) throws CothorityException {
        this.ol = ol;
        Proof p = ol.getProof(id);
        this.instance = new Instance(p);
        if (!this.instance.getContractId().equals("value")) {
            logger.error("wrong instance: {}", (Object)this.instance.getContractId());
            throw new CothorityNotFoundException("this is not a value instance");
        }
        this.value = this.instance.getData();
    }

    public ValueInstance(OmniledgerRPC ol, Proof p) throws CothorityException {
        this(ol, new InstanceId(p.getKey()));
    }

    public void update() throws CothorityException {
        this.instance = new Instance(this.ol.getProof(this.instance.getId()));
        this.value = this.instance.getData();
    }

    public Instruction evolveValueInstruction(byte[] newValue, Signer owner, int pos, int len) throws CothorityCryptoException {
        Invoke inv = new Invoke("update", "value", newValue);
        Instruction inst = new Instruction(this.instance.getId(), SubId.random().getId(), pos, len, inv);
        try {
            Request r = new Request(this.instance.getId().getDarcId(), "invoke:update", inst.hash(), Arrays.asList(owner.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(owner.sign(r.hash()), owner.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public TransactionId evolveValue(byte[] newValue, Signer owner) throws CothorityException {
        Instruction inst = this.evolveValueInstruction(newValue, owner, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.ol.sendTransaction(ct);
        return new TransactionId(this.instance.getId().getDarcId(), SubId.zero());
    }

    public void evolveValueAndWait(byte[] newValue, Signer owner) throws CothorityException {
        this.evolveValue(newValue, owner);
        for (int i = 0; i < 10; ++i) {
            Proof p = this.ol.getProof(this.instance.getId());
            Instance inst = new Instance(p);
            logger.info("Values are: {} - {}", (Object)Hex.printHexBinary(inst.getData()), (Object)Hex.printHexBinary(newValue));
            if (Arrays.equals(inst.getData(), newValue)) {
                this.value = newValue;
                return;
            }
            try {
                Thread.sleep(this.ol.getConfig().getBlockInterval().toMillis());
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new CothorityCommunicationException("couldn't find new value");
    }

    public InstanceId getId() {
        return this.instance.getId();
    }

    public byte[] getValue() throws CothorityCryptoException {
        byte[] v = new byte[this.value.length];
        System.arraycopy(this.value, 0, v, 0, this.value.length);
        return v;
    }

    public Instance getInstance() {
        return this.instance;
    }
}

