/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.lib.omniledger.darc.Signature;
import ch.epfl.dedis.proto.DarcProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Darc {
    private long version;
    private byte[] description;
    private DarcId baseID;
    private DarcId prevID;
    private Map<String, byte[]> rules;
    private List<Signature> signatures;
    private List<Darc> verificationDarcs;
    private static final Logger logger = LoggerFactory.getLogger(Darc.class);

    public Darc(Map<String, byte[]> rules, byte[] desc) {
        this.version = 0L;
        this.description = desc;
        this.baseID = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(new byte[0]);
            this.prevID = new DarcId(digest.digest());
        }
        catch (CothorityCryptoException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.rules = rules;
        this.signatures = new ArrayList<Signature>();
        this.verificationDarcs = new ArrayList<Darc>();
    }

    public Darc(List<Identity> owners, List<Identity> signers, byte[] desc) {
        this(Darc.initRules(owners, signers), desc);
    }

    public Darc(DarcProto.Darc proto) throws CothorityCryptoException {
        this.version = proto.getVersion();
        this.description = proto.getDescription().toByteArray();
        if (this.version > 0L) {
            logger.info("setting baseID");
            this.baseID = new DarcId(proto.getBaseid());
        }
        this.prevID = new DarcId(proto.getPrevid());
        this.rules = new HashMap<String, byte[]>();
        Map<String, ByteString> protoRules = proto.getRulesMap();
        for (String key : protoRules.keySet()) {
            this.rules.put(key, protoRules.get(key).toByteArray());
        }
        this.signatures = new ArrayList<Signature>();
        for (DarcProto.Signature sig : proto.getSignaturesList()) {
            this.signatures.add(new Signature(sig));
        }
        logger.info("BaseID is {}", (Object)this.baseID);
    }

    public Darc(byte[] buf) throws InvalidProtocolBufferException, CothorityCryptoException {
        this(DarcProto.Darc.parseFrom(buf));
    }

    public void setRule(String action, byte[] expression) {
        this.rules.put(action, expression);
    }

    public void increaseVersion() throws CothorityCryptoException {
        ++this.version;
        this.signatures = new ArrayList<Signature>();
        this.verificationDarcs = new ArrayList<Darc>();
    }

    public DarcProto.Darc toProto() {
        DarcProto.Darc.Builder b = DarcProto.Darc.newBuilder();
        b.setVersion(this.version);
        b.setDescription(ByteString.copyFrom((byte[])this.description));
        if (this.baseID != null) {
            b.setBaseid(ByteString.copyFrom((byte[])this.baseID.getId()));
        }
        b.setPrevid(ByteString.copyFrom((byte[])this.prevID.getId()));
        for (Map.Entry<String, byte[]> entry : this.rules.entrySet()) {
            b.putRules(entry.getKey(), ByteString.copyFrom((byte[])entry.getValue()));
        }
        this.verificationDarcs.forEach(d -> b.addVerificationdarcs(d.toProto()));
        this.signatures.forEach(s -> b.addSignatures(s.toProto()));
        return b.build();
    }

    public DarcId getId() throws CothorityCryptoException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(Darc.longToArr8(this.version));
            digest.update(this.description);
            if (this.baseID != null) {
                digest.update(this.baseID.getId());
            }
            digest.update(this.prevID.getId());
            this.sortedAction().forEach(k -> {
                byte[] expr = this.rules.get(k);
                digest.update(k.getBytes());
                digest.update(expr);
            });
            return new DarcId(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPrevId(DarcId id) {
        this.prevID = id;
    }

    public void setBaseId(DarcId id) {
        this.baseID = id;
    }

    public void setPrevId(Darc d) throws CothorityCryptoException {
        this.setPrevId(d.getId());
    }

    public DarcId getBaseId() throws CothorityCryptoException {
        if (this.version == 0L) {
            return this.getId();
        }
        return this.baseID;
    }

    public DarcId getPrevID() {
        return this.prevID;
    }

    public long getVersion() {
        return this.version;
    }

    public Darc copy() throws CothorityCryptoException {
        HashMap<String, byte[]> rs = new HashMap<String, byte[]>();
        for (String k : this.rules.keySet()) {
            rs.put(k, this.rules.get(k));
        }
        Darc c = new Darc(rs, (byte[])this.description.clone());
        c.version = this.version;
        return c;
    }

    public Darc copyEvolve() throws CothorityCryptoException {
        HashMap<String, byte[]> rs = new HashMap<String, byte[]>();
        for (String k : this.rules.keySet()) {
            rs.put(k, this.rules.get(k));
        }
        Darc c = new Darc(rs, (byte[])this.description.clone());
        c.version = this.version + 1L;
        c.prevID = this.getId();
        c.baseID = this.getBaseId();
        return c;
    }

    public String toString() {
        try {
            String base = Hex.printHexBinary(this.getBaseId().getId());
            if (this.baseID != null) {
                base = String.format("stored: %s", Hex.printHexBinary(this.baseID.getId()));
            }
            String ret = String.format("Base: %s\nId: %s\nPrevId: %s\nVersion: %d\nRules:", base, Hex.printHexBinary(this.getId().getId()), Hex.printHexBinary(this.getPrevID().getId()), this.version);
            for (String r : this.rules.keySet()) {
                ret = ret + String.format("\n%s - %s", r, Hex.printHexBinary(this.rules.get(r)));
            }
            ret = ret + String.format("\nDescription: %s", Hex.printHexBinary(this.description));
            return ret;
        }
        catch (CothorityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, byte[]> initRules(List<Identity> owners, List<Identity> signers) {
        HashMap<String, byte[]> rs = new HashMap<String, byte[]>();
        List ownerIDs = owners.stream().map(Identity::toString).collect(Collectors.toList());
        rs.put("invoke:evolve", String.join((CharSequence)" & ", ownerIDs).getBytes());
        List signerIDs = signers.stream().map(Identity::toString).collect(Collectors.toList());
        rs.put("_sign", String.join((CharSequence)" | ", signerIDs).getBytes());
        return rs;
    }

    private Stream<String> sortedAction() {
        return this.rules.keySet().stream().sorted();
    }

    private static byte[] intToArr8(int x) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.putInt(x);
        return b.array();
    }

    private static byte[] longToArr8(long x) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.putLong(x);
        return b.array();
    }
}

