/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.darc.Darc;
import ch.epfl.dedis.lib.omniledger.darc.DarcId;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.proto.DarcProto;
import com.google.protobuf.ByteString;

public class IdentityDarc
implements Identity {
    private DarcId darcID;

    public IdentityDarc(DarcProto.IdentityDarc proto) throws CothorityCryptoException {
        this.darcID = new DarcId(proto.getId().toByteArray());
    }

    public IdentityDarc(DarcId darcID) {
        this.darcID = darcID;
    }

    public IdentityDarc(Darc darc) throws CothorityCryptoException {
        this(darc.getId());
    }

    @Override
    public boolean verify(byte[] msg, byte[] signature) {
        return false;
    }

    @Override
    public DarcProto.Identity toProto() {
        DarcProto.Identity.Builder bid = DarcProto.Identity.newBuilder();
        DarcProto.IdentityDarc.Builder bdd = DarcProto.IdentityDarc.newBuilder();
        bdd.setId(ByteString.copyFrom((byte[])this.darcID.getId()));
        bid.setDarc(bdd);
        return bid.build();
    }

    public DarcId getDarcId() {
        return this.darcID;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityDarc that = (IdentityDarc)o;
        return this.darcID != null ? this.darcID.equals(that.darcID) : that.darcID == null;
    }

    public int hashCode() {
        return this.darcID != null ? this.darcID.hashCode() : 0;
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.typeString(), Hex.printHexBinary(this.darcID.getId()).toLowerCase());
    }

    @Override
    public String typeString() {
        return "darc";
    }
}

