/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.SchnorrSig;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import ch.epfl.dedis.lib.omniledger.darc.SignerEd25519;
import ch.epfl.dedis.proto.DarcProto;
import com.google.protobuf.ByteString;

public class IdentityEd25519
implements Identity {
    private Point pub;

    public IdentityEd25519(DarcProto.IdentityEd25519 proto) {
        this.pub = new Ed25519Point(proto.getPoint());
    }

    public IdentityEd25519(Signer signer) throws CothorityCryptoException {
        if (!SignerEd25519.class.isInstance(signer)) {
            throw new CothorityCryptoException("Wrong signer type: " + signer.toString());
        }
        this.pub = new Ed25519Point(signer.getPublic());
    }

    @Override
    public boolean verify(byte[] msg, byte[] signature) {
        return new SchnorrSig(signature).verify(msg, this.pub);
    }

    @Override
    public DarcProto.Identity toProto() {
        DarcProto.Identity.Builder bid = DarcProto.Identity.newBuilder();
        DarcProto.IdentityEd25519.Builder bed = DarcProto.IdentityEd25519.newBuilder();
        bed.setPoint(ByteString.copyFrom((byte[])this.pub.toBytes()));
        bid.setEd25519(bed);
        return bid.build();
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.typeString(), this.pub.toString().toLowerCase());
    }

    @Override
    public String typeString() {
        return "ed25519";
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof IdentityEd25519)) {
            return false;
        }
        IdentityEd25519 otherEd = (IdentityEd25519)other;
        return this.pub.equals(otherEd.pub);
    }
}

