/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.darc.Darc;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.lib.omniledger.darc.IdentityDarc;
import ch.epfl.dedis.lib.omniledger.darc.IdentityEd25519;
import ch.epfl.dedis.lib.omniledger.darc.IdentityX509EC;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import ch.epfl.dedis.lib.omniledger.darc.SignerEd25519;
import ch.epfl.dedis.lib.omniledger.darc.SignerX509EC;
import ch.epfl.dedis.proto.DarcProto;

public class IdentityFactory {
    public static Identity New(DarcProto.Identity proto) throws CothorityCryptoException {
        if (proto.hasEd25519()) {
            return new IdentityEd25519(proto.getEd25519());
        }
        if (proto.hasDarc()) {
            return new IdentityDarc(proto.getDarc());
        }
        if (proto.hasX509Ec()) {
            return new IdentityX509EC(proto.getX509Ec());
        }
        throw new CothorityCryptoException("No identity present");
    }

    public static Identity New(Signer signer) throws CothorityCryptoException {
        if (SignerEd25519.class.isInstance(signer)) {
            return new IdentityEd25519(signer);
        }
        if (SignerX509EC.class.isInstance(signer)) {
            return new IdentityX509EC(signer);
        }
        throw new CothorityCryptoException("Cannot make Identity out of " + signer.toString());
    }

    public static Identity New(Darc darc) throws CothorityCryptoException {
        return new IdentityDarc(darc);
    }
}

