/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.lib.omniledger.darc.IdentityFactory;
import ch.epfl.dedis.proto.DarcProto;
import com.google.protobuf.ByteString;

public class Signature {
    public byte[] signature;
    public Identity signer;

    public Signature(byte[] signature, Identity signer) {
        this.signature = signature;
        this.signer = signer;
    }

    public Signature(DarcProto.Signature sig) throws CothorityCryptoException {
        this.signature = sig.getSignature().toByteArray();
        this.signer = IdentityFactory.New(sig.getSigner());
    }

    public DarcProto.Signature toProto() {
        DarcProto.Signature.Builder b = DarcProto.Signature.newBuilder();
        b.setSignature(ByteString.copyFrom((byte[])this.signature));
        b.setSigner(this.signer.toProto());
        return b.build();
    }
}

