/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.omniledger.darc;

import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.omniledger.darc.Identity;
import ch.epfl.dedis.lib.omniledger.darc.IdentityFactory;
import ch.epfl.dedis.lib.omniledger.darc.Signer;
import java.io.IOException;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignerX509EC
implements Signer {
    private final Logger logger = LoggerFactory.getLogger(SignerX509EC.class);

    @Override
    public abstract byte[] sign(byte[] var1) throws Signer.SignRequestRejectedException;

    @Override
    public Scalar getPrivate() throws CothorityCryptoException {
        throw new CothorityCryptoException("cannot reveal private key");
    }

    @Override
    public Point getPublic() throws CothorityCryptoException {
        throw new CothorityCryptoException("non-ed25519 public keys not yet implemented");
    }

    @Override
    public Identity getIdentity() throws CothorityCryptoException {
        return IdentityFactory.New(this);
    }

    @Override
    public byte[] serialize() throws IOException {
        throw new IllegalStateException("It is not possible to serialise keycard signer as private key is in the card");
    }

    public byte[] publicBytes() {
        return this.getPublicKey().getEncoded();
    }

    public abstract PublicKey getPublicKey();
}

