/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.proto.OCSProto;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DecryptKey {
    public List<Point> Cs = new ArrayList<Point>();
    public Point XhatEnc;
    public Point X;

    public DecryptKey() {
    }

    public DecryptKey(OCSProto.DecryptKeyReply reply, Point X) {
        this();
        reply.getCsList().forEach(C -> this.Cs.add(new Ed25519Point((ByteString)C)));
        this.XhatEnc = new Ed25519Point(reply.getXhatenc());
        this.X = X;
    }

    public byte[] getKeyMaterial(OCSProto.Write write, Scalar reader) throws CothorityCryptoException {
        ArrayList Cs = new ArrayList();
        write.getCsList().forEach(cs -> Cs.add(new Ed25519Point((ByteString)cs)));
        Scalar xc = reader.reduce();
        Scalar xcInv = xc.negate();
        Point XhatDec = this.X.mul(xcInv);
        Point Xhat = this.XhatEnc.add(XhatDec);
        Point XhatInv = Xhat.negate();
        byte[] keyMaterial = "".getBytes();
        for (Point C : Cs) {
            Point keyEd25519PointHat = C.add(XhatInv);
            byte[] keyPart = keyEd25519PointHat.data();
            int lastpos = keyMaterial.length;
            keyMaterial = Arrays.copyOfRange(keyMaterial, 0, keyMaterial.length + keyPart.length);
            System.arraycopy(keyPart, 0, keyMaterial, lastpos, keyPart.length);
        }
        return keyMaterial;
    }

    public String toString() {
        return String.format("Cs.length: %d\nXhatEnc: %bytes\nX: %bytes", this.Cs.size(), this.XhatEnc, this.X);
    }
}

