/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.crypto.Encryption;
import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.ocs.WriteRequest;
import ch.epfl.dedis.ocs.WriteRequestId;
import java.util.Arrays;

public class Document {
    private byte[] dataEncrypted;
    private byte[] keyMaterial;
    private byte[] dataPublic;
    private WriteRequestId writeRequestId;
    private Darc readers;

    public Document(byte[] dataEncrypted, byte[] keyMaterial, byte[] dataPublic, Darc readers, WriteRequestId writeRequestId) {
        this.dataEncrypted = dataEncrypted;
        this.keyMaterial = keyMaterial;
        this.dataPublic = dataPublic;
        this.writeRequestId = writeRequestId;
        this.readers = readers;
    }

    public Document(byte[] dataEncrypted, byte[] keyMaterial, byte[] dataPublic, Darc readers) {
        this(dataEncrypted, keyMaterial, dataPublic, readers, null);
    }

    public Document(byte[] data, int keylen, Darc readers, byte[] dataPublic) throws CothorityCryptoException {
        Encryption.keyIv key = new Encryption.keyIv(keylen);
        this.keyMaterial = key.getKeyMaterial();
        this.dataEncrypted = Encryption.encryptData(data, key.getKeyMaterial());
        this.readers = readers;
        this.dataPublic = dataPublic;
    }

    public Document(byte[] data, int keylen, Darc readers) throws CothorityCryptoException {
        this(data, keylen, readers, new byte[0]);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Document)) {
            return false;
        }
        Document otherDoc = (Document)other;
        boolean wrid = true;
        if (this.writeRequestId != null) {
            wrid = this.writeRequestId.equals(otherDoc.writeRequestId);
        }
        return Arrays.equals(otherDoc.dataEncrypted, this.dataEncrypted) && Arrays.equals(otherDoc.dataPublic, this.dataPublic) && Arrays.equals(otherDoc.keyMaterial, this.keyMaterial) && otherDoc.readers.equals(this.readers) && wrid;
    }

    public WriteRequest getWriteRequest() {
        return new WriteRequest(this.dataEncrypted, this.keyMaterial, this.readers, this.dataPublic);
    }

    public byte[] getDataEncrypted() {
        return this.dataEncrypted;
    }

    public byte[] getKeyMaterial() {
        return this.keyMaterial;
    }

    public byte[] getDataPublic() {
        return this.dataPublic;
    }

    public WriteRequestId getWriteRequestId() {
        return this.writeRequestId;
    }

    public Darc getReaders() {
        return this.readers;
    }

    public String toString() {
        String wrid = "null";
        if (this.writeRequestId != null) {
            wrid = this.writeRequestId.toString();
        }
        return String.format("dataEncrypted: %s\ndataPublic: %s\nkeyMaterial: %s\nreaders: %s\nwriteRequestId: %s", Hex.printHexBinary(this.dataEncrypted), Hex.printHexBinary(this.dataPublic), Hex.printHexBinary(this.keyMaterial), this.readers.toString(), wrid);
    }
}

