/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.KeyPair;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.DarcSignature;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.darc.SignerEd25519;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.ocs.DecryptKey;
import ch.epfl.dedis.ocs.Document;
import ch.epfl.dedis.ocs.OnchainSecretsRPC;
import ch.epfl.dedis.ocs.ReadRequest;
import ch.epfl.dedis.ocs.ReadRequestId;
import ch.epfl.dedis.ocs.WriteRequest;
import ch.epfl.dedis.ocs.WriteRequestId;
import ch.epfl.dedis.proto.OCSProto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnchainSecrets
extends OnchainSecretsRPC {
    private final Logger logger = LoggerFactory.getLogger(OnchainSecrets.class);

    public OnchainSecrets(Roster roster, SkipblockId ocsID) throws CothorityCommunicationException, CothorityCryptoException {
        super(roster, ocsID);
    }

    public OnchainSecrets(Roster roster, Darc admin) throws CothorityCommunicationException, CothorityCryptoException {
        super(roster, admin);
    }

    public SignaturePath getDarcPath(DarcId base, Signer identity, int role) throws CothorityCommunicationException, CothorityCryptoException {
        return this.getDarcPath(base, IdentityFactory.New(identity), role);
    }

    public Darc addIdentityToDarc(Darc darc, Identity identity, Signer signer, int role) throws CothorityCommunicationException, CothorityCryptoException {
        Darc newDarc = darc.copy();
        switch (role) {
            case 1: {
                newDarc.addUser(identity);
                break;
            }
            case 0: {
                newDarc.addOwner(identity);
                break;
            }
        }
        newDarc.setEvolution(darc, signer);
        this.updateDarc(newDarc);
        return newDarc;
    }

    public Darc addIdentityToDarc(Darc darc, Signer identity, Signer signer, int role) throws CothorityCommunicationException, CothorityCryptoException {
        Identity newI = IdentityFactory.New(identity);
        return this.addIdentityToDarc(darc, newI, signer, role);
    }

    public Darc addIdentityToDarc(DarcId id, Signer identity, Signer signer, int role) throws CothorityCommunicationException, CothorityCryptoException {
        List<Darc> darcs = this.getLatestDarc(id);
        return this.addIdentityToDarc(darcs.get(darcs.size() - 1), identity, signer, role);
    }

    public WriteRequest publishDocument(Document doc, Signer writer) throws CothorityCryptoException, CothorityCommunicationException {
        WriteRequest wr = doc.getWriteRequest();
        DarcSignature sig = wr.getSignature(this, writer);
        return this.createWriteRequest(wr, sig);
    }

    public Document getDocument(WriteRequestId wrId, Signer reader) throws CothorityCryptoException, CothorityCommunicationException {
        if (!(reader instanceof SignerEd25519)) {
            throw new IllegalStateException("getDocument can only be used with SignerEd25519");
        }
        OCSProto.Write document = this.getWrite(wrId);
        Darc readerDarc = new Darc(document.getReader());
        ReadRequestId rrid = this.createReadRequest(new ReadRequest(this, wrId, reader));
        DecryptKey dk = this.getDecryptionKey(rrid);
        OCSProto.Write write = this.getWrite(wrId);
        byte[] keyMaterial = dk.getKeyMaterial(write, reader.getPrivate());
        return new Document(write.getData().toByteArray(), keyMaterial, write.getExtradata().toByteArray(), readerDarc, wrId);
    }

    public Document getDocumentEphemeral(WriteRequestId wrId, Signer reader) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.Write write = this.getWrite(wrId);
        Darc readerDarc = new Darc(write.getReader());
        ReadRequestId rrId = this.createReadRequest(new ReadRequest(this, wrId, reader));
        KeyPair kp = new KeyPair();
        DarcSignature sig = new DarcSignature(kp.point.toBytes(), readerDarc, reader, 1);
        DecryptKey dk = this.getDecryptionKeyEphemeral(rrId, sig, kp.point);
        byte[] keyMaterial = dk.getKeyMaterial(write, kp.scalar);
        return new Document(write.getData().toByteArray(), keyMaterial, write.getExtradata().toByteArray(), readerDarc, wrId);
    }

    public Darc removeIdentityFromDarc(Darc darc, Identity identity, Signer signer, int role) throws CothorityCommunicationException, CothorityCryptoException {
        Darc newDarc = darc.copy();
        switch (role) {
            case 1: {
                newDarc.removeUser(identity);
                break;
            }
            case 0: {
                newDarc.removeOwner(identity);
                break;
            }
        }
        newDarc.setEvolution(darc, signer);
        this.updateDarc(newDarc);
        return newDarc;
    }
}

