/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Hex;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.DarcSignature;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.ocs.DecryptKey;
import ch.epfl.dedis.ocs.ReadRequest;
import ch.epfl.dedis.ocs.ReadRequestId;
import ch.epfl.dedis.ocs.WriteRequest;
import ch.epfl.dedis.ocs.WriteRequestId;
import ch.epfl.dedis.proto.DarcOCSProto;
import ch.epfl.dedis.proto.OCSProto;
import ch.epfl.dedis.proto.SkipchainProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnchainSecretsRPC {
    protected SkipblockId ocsID;
    protected Point X;
    protected Darc adminDarc;
    protected Roster roster;
    private final Logger logger = LoggerFactory.getLogger(OnchainSecretsRPC.class);

    OnchainSecretsRPC(Roster roster, SkipblockId ocsID) throws CothorityCommunicationException {
        this.ocsID = ocsID;
        this.roster = roster;
        this.X = this.getSharedPublicKey();
        try {
            OCSProto.Transaction transaction = this.getTransaction(ocsID);
            this.adminDarc = new Darc(transaction.getDarc());
            this.logger.info("adminDarc is: " + this.adminDarc.toString());
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException(e.toString());
        }
    }

    OnchainSecretsRPC(Roster roster, Darc admins) throws CothorityCommunicationException {
        this.roster = roster;
        this.createSkipchains(admins);
        this.adminDarc = admins;
    }

    public boolean verify() {
        boolean ok = true;
        for (ServerIdentity n : this.roster.getNodes()) {
            this.logger.info("Testing node {}", (Object)n.getAddress());
            try {
                n.GetStatus();
            }
            catch (CothorityCommunicationException e) {
                this.logger.warn("Failing node {}", (Object)n.getAddress());
                ok = false;
            }
        }
        return ok;
    }

    public void createSkipchains(Darc writers) throws CothorityCommunicationException {
        OCSProto.CreateSkipchainsRequest.Builder request = OCSProto.CreateSkipchainsRequest.newBuilder();
        request.setRoster(this.roster.toProto());
        request.setWriters(writers.toProto());
        ByteString msg = this.roster.sendMessage("OnChainSecrets/CreateSkipchainsRequest", request.build());
        try {
            OCSProto.CreateSkipchainsReply reply = OCSProto.CreateSkipchainsReply.parseFrom(msg);
            this.X = new Ed25519Point(reply.getX());
            this.logger.debug("Got reply: {}", (Object)reply.toString());
            this.ocsID = new SkipblockId(reply.getOcs().getHash().toByteArray());
            this.logger.info("Initialised OCS: {}", (Object)this.ocsID.toString());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e.toString());
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException(e.toString());
        }
    }

    public void updateDarc(Darc newAccount) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.UpdateDarc.Builder request = OCSProto.UpdateDarc.newBuilder();
        request.setOcs(ByteString.copyFrom((byte[])this.ocsID.getId()));
        request.setDarc(newAccount.toProto());
        ByteString msg = this.roster.sendMessage("OnChainSecrets/UpdateDarc", request.build());
        try {
            OCSProto.UpdateDarcReply reply = OCSProto.UpdateDarcReply.parseFrom(msg);
            this.logger.debug("received reply: {}", (Object)reply.toString());
            this.logger.info("Updated darc {} stored in block: {}", (Object)newAccount.getId().toString(), (Object)Hex.printHexBinary(reply.getSb().getHash().toByteArray()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public Point getSharedPublicKey() throws CothorityCommunicationException {
        OCSProto.SharedPublicRequest.Builder request = OCSProto.SharedPublicRequest.newBuilder();
        request.setGenesis(ByteString.copyFrom((byte[])this.ocsID.getId()));
        ByteString msg = this.roster.sendMessage("OnChainSecrets/SharedPublicRequest", request.build());
        try {
            OCSProto.SharedPublicReply reply = OCSProto.SharedPublicReply.parseFrom(msg);
            this.logger.info("Got shared public symmetricKey");
            return new Ed25519Point(reply.getX());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public WriteRequest createWriteRequest(WriteRequest wr, DarcSignature signature) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.WriteRequest.Builder request = OCSProto.WriteRequest.newBuilder();
        request.setOcs(ByteString.copyFrom((byte[])this.ocsID.getId()));
        request.setWrite(wr.toProto(this.X, this.ocsID));
        request.setReaders(wr.owner.toProto());
        request.setSignature(signature.toProto());
        ByteString msg = this.roster.sendMessage("OnChainSecrets/WriteRequest", request.build());
        try {
            OCSProto.WriteReply reply = OCSProto.WriteReply.parseFrom(msg);
            wr.id = new WriteRequestId(reply.getSb().getHash().toByteArray());
            this.logger.info("Published document " + wr.id.toString());
            return wr;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SignaturePath getDarcPath(DarcId base, Identity identity, int role) throws CothorityCommunicationException {
        OCSProto.GetDarcPath.Builder request = OCSProto.GetDarcPath.newBuilder();
        request.setOcs(ByteString.copyFrom((byte[])this.ocsID.getId()));
        request.setBasedarcid(ByteString.copyFrom((byte[])base.getId()));
        request.setIdentity(identity.toProto());
        request.setRole(role);
        ByteString msg = this.roster.sendMessage("OnChainSecrets/GetDarcPath", request.build());
        try {
            OCSProto.GetDarcPathReply reply = OCSProto.GetDarcPathReply.parseFrom(msg);
            ArrayList<Darc> darcs = new ArrayList<Darc>();
            for (DarcOCSProto.Darc d : reply.getPathList()) {
                darcs.add(new Darc(d));
            }
            return new SignaturePath(darcs, identity, role);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
        catch (Exception e) {
            throw new CothorityCommunicationException(e.toString());
        }
    }

    public ReadRequestId createReadRequest(ReadRequest rr) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.ReadRequest.Builder request = OCSProto.ReadRequest.newBuilder();
        request.setOcs(ByteString.copyFrom((byte[])this.ocsID.getId()));
        request.setRead(rr.ToProto());
        ByteString msg = this.roster.sendMessage("OnChainSecrets/ReadRequest", request.build());
        try {
            OCSProto.ReadReply reply = OCSProto.ReadReply.parseFrom(msg);
            this.logger.info("Created a read-request");
            return new ReadRequestId(reply.getSb().getHash().toByteArray());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SkipchainProto.SkipBlock getSkipblock(SkipblockId id) throws CothorityCommunicationException {
        SkipchainProto.GetSingleBlock request = SkipchainProto.GetSingleBlock.newBuilder().setId(ByteString.copyFrom((byte[])id.getId())).build();
        ByteString msg = this.roster.sendMessage("Skipchain/GetSingleBlock", request);
        try {
            SkipchainProto.SkipBlock sb = SkipchainProto.SkipBlock.parseFrom(msg);
            this.logger.debug("Got the following skipblock: {}", (Object)sb);
            this.logger.info("Successfully read skipblock");
            return sb;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public OCSProto.Transaction getTransaction(SkipblockId id) throws CothorityCommunicationException {
        try {
            SkipchainProto.SkipBlock sb = this.getSkipblock(id);
            this.logger.debug("Got the following skipblock: {}", (Object)sb);
            this.logger.info("Successfully read skipblock");
            return OCSProto.Transaction.parseFrom(sb.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public OCSProto.Write getWrite(WriteRequestId id) throws CothorityCommunicationException {
        OCSProto.Transaction transaction = this.getTransaction(id);
        this.logger.debug("Getting write-request from skipblock {}", (Object)id);
        if (!transaction.hasWrite()) {
            throw new CothorityCommunicationException("This is not an getId from a write-request");
        }
        return transaction.getWrite();
    }

    public OCSProto.Read getRead(ReadRequestId id) throws CothorityCommunicationException {
        OCSProto.Transaction transaction = this.getTransaction(id);
        this.logger.debug("Getting read-request from skipblock {}", (Object)id);
        if (!transaction.hasRead()) {
            throw new CothorityCommunicationException("This is not an getId from a read-request");
        }
        return transaction.getRead();
    }

    public DecryptKey getDecryptionKey(ReadRequestId id) throws CothorityCommunicationException {
        OCSProto.DecryptKeyRequest.Builder request = OCSProto.DecryptKeyRequest.newBuilder();
        request.setRead(ByteString.copyFrom((byte[])id.getId()));
        ByteString msg = this.roster.sendMessage("OnChainSecrets/DecryptKeyRequest", request.build());
        try {
            OCSProto.DecryptKeyReply reply = OCSProto.DecryptKeyReply.parseFrom(msg);
            this.logger.info("got decryption symmetricKey");
            return new DecryptKey(reply, this.X);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public DecryptKey getDecryptionKeyEphemeral(ReadRequestId id, DarcSignature signature, Point ephemeral) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.DecryptKeyRequest.Builder request = OCSProto.DecryptKeyRequest.newBuilder();
        request.setRead(ByteString.copyFrom((byte[])id.getId()));
        request.setEphemeral(ephemeral.toProto());
        request.setSignature(signature.toProto());
        ByteString msg = this.roster.sendMessage("OnChainSecrets/DecryptKeyRequest", request.build());
        try {
            OCSProto.DecryptKeyReply reply = OCSProto.DecryptKeyReply.parseFrom(msg);
            this.logger.info("got decryption symmetricKey");
            return new DecryptKey(reply, this.X);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public List<Darc> getLatestDarc(DarcId id) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.GetLatestDarc.Builder request = OCSProto.GetLatestDarc.newBuilder();
        request.setOcs(ByteString.copyFrom((byte[])this.ocsID.getId()));
        request.setDarcid(ByteString.copyFrom((byte[])id.getId()));
        ByteString msg = this.roster.sendMessage("OnChainSecrets/GetLatestDarc", request.build());
        try {
            OCSProto.GetLatestDarcReply reply = OCSProto.GetLatestDarcReply.parseFrom(msg);
            this.logger.info("got latestdarc");
            ArrayList<Darc> ret = new ArrayList<Darc>();
            for (DarcOCSProto.Darc d : reply.getDarcsList()) {
                ret.add(new Darc(d));
            }
            return ret;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SkipblockId getGenesis() {
        return this.ocsID;
    }

    public Darc getAdminDarc() throws CothorityCryptoException, CothorityCommunicationException {
        List<Darc> admins = this.getLatestDarc(this.adminDarc.getId());
        return admins.get(admins.size() - 1);
    }

    public SkipblockId getID() {
        return this.ocsID;
    }

    public Point getX() {
        return this.X;
    }

    public Roster getRoster() {
        return this.roster;
    }
}

