/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcSignature;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.IdentityFactory;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.ocs.OnchainSecretsRPC;
import ch.epfl.dedis.ocs.WriteRequestId;
import ch.epfl.dedis.proto.OCSProto;
import com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadRequest {
    private WriteRequestId wrId;
    private DarcSignature signature;
    private final Logger logger = LoggerFactory.getLogger(ReadRequest.class);

    public ReadRequest(OnchainSecretsRPC ocs, WriteRequestId wrId, Signer reader) throws CothorityCommunicationException, CothorityCryptoException {
        OCSProto.Write wr = ocs.getWrite(wrId);
        this.wrId = wrId;
        Darc readDarc = new Darc(wr.getReader());
        Identity readerId = IdentityFactory.New(reader);
        SignaturePath path = ocs.getDarcPath(readDarc.getId(), readerId, 1);
        for (Darc d : path.getDarcs()) {
            this.logger.debug("Path: " + d.toString());
        }
        this.signature = new DarcSignature(wrId.getId(), path, reader);
    }

    public ReadRequest(WriteRequestId wrId, DarcSignature signature) {
        this.wrId = wrId;
        this.signature = signature;
    }

    public OCSProto.Read ToProto() {
        OCSProto.Read.Builder ocsRead = OCSProto.Read.newBuilder();
        ocsRead.setDataid(ByteString.copyFrom((byte[])this.wrId.getId()));
        ocsRead.setSignature(this.signature.toProto());
        return ocsRead.build();
    }
}

