/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.ocs;

import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Ed25519Scalar;
import ch.epfl.dedis.lib.crypto.Encryption;
import ch.epfl.dedis.lib.crypto.KeyPair;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcSignature;
import ch.epfl.dedis.lib.darc.SignaturePath;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.ocs.OnchainSecretsRPC;
import ch.epfl.dedis.ocs.WriteRequestId;
import ch.epfl.dedis.proto.OCSProto;
import com.google.protobuf.ByteString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class WriteRequest {
    public byte[] dataEnc;
    public byte[] keyMaterial;
    public Darc owner;
    public byte[] extraData;
    public WriteRequestId id;

    public WriteRequest(WriteRequest wr) {
        this.id = wr.id;
        this.dataEnc = wr.dataEnc;
        this.extraData = wr.extraData;
        this.keyMaterial = wr.keyMaterial;
        this.owner = wr.owner;
    }

    public WriteRequest(byte[] data, int keylen, Darc owner) throws CothorityCryptoException {
        Encryption.keyIv key = new Encryption.keyIv(keylen);
        this.keyMaterial = key.getKeyMaterial();
        this.dataEnc = Encryption.encryptData(data, key.getKeyMaterial());
        this.owner = owner;
        this.extraData = "".getBytes();
    }

    public WriteRequest(String data, int keylen, Darc owner) throws CothorityCryptoException {
        this(data.getBytes(), keylen, owner);
    }

    public WriteRequest(byte[] dataEnc, byte[] keyMaterial, Darc owner, byte[] extraData) {
        this.dataEnc = dataEnc;
        this.keyMaterial = keyMaterial;
        this.owner = owner;
        this.extraData = extraData;
    }

    public OCSProto.Write toProto(Point X, SkipblockId scid) throws CothorityCommunicationException {
        OCSProto.Write.Builder write = OCSProto.Write.newBuilder();
        write.setExtradata(ByteString.copyFrom((byte[])this.extraData));
        write.setReader(this.owner.toProto());
        try {
            write.setData(ByteString.copyFrom((byte[])this.dataEnc));
            KeyPair randkp = new KeyPair();
            Scalar r = randkp.scalar;
            Point U = randkp.point;
            write.setU(U.toProto());
            Point C = X.mul(r);
            ArrayList<Point> Cs = new ArrayList<Point>();
            for (int from = 0; from < this.keyMaterial.length; from += 30) {
                int to = from + 30;
                if (to > this.keyMaterial.length) {
                    to = this.keyMaterial.length;
                }
                Point keyEd25519Point = Ed25519Point.embed(Arrays.copyOfRange(this.keyMaterial, from, to));
                Point Ckey = C.add(keyEd25519Point);
                Cs.add(Ckey);
                write.addCs(Ckey.toProto());
            }
            Point gBar = Ed25519Point.base().mul(new Ed25519Scalar(scid.getId()));
            Point Ubar = gBar.mul(r);
            write.setUbar(Ubar.toProto());
            KeyPair skp = new KeyPair();
            Scalar s = skp.scalar;
            Point w = skp.point;
            Point wBar = gBar.mul(s);
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            for (Point c : Cs) {
                hash.update(c.toBytes());
            }
            hash.update(U.toBytes());
            hash.update(Ubar.toBytes());
            hash.update(w.toBytes());
            hash.update(wBar.toBytes());
            hash.update(this.owner.getId().getId());
            Ed25519Scalar E = new Ed25519Scalar(hash.digest());
            write.setE(E.toProto());
            Scalar F = s.add(E.mul(r));
            write.setF(F.toProto());
            return write.build();
        }
        catch (CothorityCryptoException e) {
            throw new CothorityCommunicationException("Encryption problem" + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CothorityCommunicationException("Hashing-error");
        }
    }

    public DarcSignature getSignature(OnchainSecretsRPC ocs, Signer publisher) throws CothorityCryptoException, CothorityCommunicationException {
        SignaturePath path = ocs.getDarcPath(ocs.getAdminDarc().getBaseId(), publisher.getIdentity(), 1);
        return new DarcSignature(this.owner.getId().getId(), path, publisher);
    }
}

