/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.List;

public class Instance {
    private InstanceId id;
    private String contractId;
    private DarcId darcId;
    private byte[] data;

    private Instance(InstanceId id, String cid, DarcId did, byte[] data) {
        this.id = id;
        this.contractId = cid;
        this.darcId = did;
        this.data = data;
    }

    public static Instance fromProof(Proof p) throws CothorityNotFoundException {
        DarcId darcId;
        if (!p.matches()) {
            throw new CothorityNotFoundException("this is a proof of absence");
        }
        List<byte[]> values = p.getValues();
        try {
            darcId = new DarcId(values.get(2));
        }
        catch (CothorityCryptoException e) {
            throw new CothorityNotFoundException("couldn't get darc from proof: " + e.getMessage());
        }
        return new Instance(new InstanceId(p.getKey()), new String(values.get(1)), darcId, values.get(0));
    }

    public static Instance fromByzcoin(ByzCoinRPC bc, InstanceId id) throws CothorityCommunicationException, CothorityNotFoundException {
        return Instance.fromProof(bc.getProof(id));
    }

    public InstanceId getId() {
        return this.id;
    }

    public String getContractId() {
        return this.contractId;
    }

    public DarcId getDarcId() {
        return this.darcId;
    }

    public byte[] getData() {
        return this.data;
    }
}

