/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.lib.HashId;
import ch.epfl.dedis.lib.Hex;
import com.google.protobuf.ByteString;
import java.util.Arrays;

public class InstanceId
implements HashId {
    private final byte[] id;
    public static final int length = 32;

    public InstanceId(byte[] id) {
        if (id.length != 32) {
            throw new RuntimeException("need 32 bytes for instanceID, only got " + id.length);
        }
        this.id = Arrays.copyOf(id, id.length);
    }

    public InstanceId(ByteString bs) {
        this(bs.toByteArray());
    }

    @Override
    public byte[] getId() {
        return Arrays.copyOf(this.id, this.id.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.id, ((InstanceId)o).id);
    }

    public int hashCode() {
        return Arrays.hashCode(this.id);
    }

    public String toString() {
        return Hex.printHexBinary(this.id);
    }

    public ByteString toByteString() {
        return ByteString.copyFrom((byte[])this.id);
    }

    public static InstanceId zero() {
        byte[] z = new byte[32];
        return new InstanceId(z);
    }
}

