/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import java.util.HashSet;
import java.util.Set;

public class Subscription {
    private ByzCoinRPC bc;
    private AggregateReceiver aggr;
    private ServerIdentity.StreamingConn conn;

    public Subscription(ByzCoinRPC bc) {
        this.bc = bc;
        this.aggr = new AggregateReceiver();
    }

    public void subscribeSkipBlock(SkipBlockReceiver br) throws CothorityCommunicationException {
        this.aggr.add(br);
        if (this.aggr.size() == 1) {
            this.conn = this.bc.streamTransactions(this.aggr);
        }
    }

    public void unsubscribeSkipBlock(SkipBlockReceiver br) {
        this.aggr.remove(br);
        if (this.aggr.size() == 0) {
            this.conn.close();
        }
    }

    public boolean isClosed() {
        if (this.conn == null) {
            return true;
        }
        return this.conn.isClosed();
    }

    class AggregateReceiver
    implements SkipBlockReceiver {
        private Set<SkipBlockReceiver> blockReceivers = new HashSet<SkipBlockReceiver>();

        private AggregateReceiver() {
        }

        @Override
        public void receive(SkipBlock block) {
            this.blockReceivers.forEach(br -> br.receive(block));
        }

        @Override
        public void error(String s) {
            this.blockReceivers.forEach(br -> br.error(s));
        }

        private boolean add(SkipBlockReceiver r) {
            return this.blockReceivers.add(r);
        }

        private boolean remove(SkipBlockReceiver r) {
            return this.blockReceivers.remove(r);
        }

        private int size() {
            return this.blockReceivers.size();
        }
    }

    public static interface SkipBlockReceiver {
        public void receive(SkipBlock var1);

        public void error(String var1);
    }
}

