/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.contracts;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.contracts.DarcInstance;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Request;
import ch.epfl.dedis.lib.darc.Signature;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueInstance {
    public static String ContractId = "value";
    private Instance instance;
    private ByzCoinRPC bc;
    private byte[] value;
    private static final Logger logger = LoggerFactory.getLogger(ValueInstance.class);

    public ValueInstance(ByzCoinRPC bc, DarcId spawnerDarcId, Signer spawnerSigner, byte[] value) throws CothorityException {
        DarcInstance spawner = DarcInstance.fromByzCoin(bc, spawnerDarcId);
        ArrayList<Argument> args = new ArrayList<Argument>();
        this.instance = spawner.spawnInstanceAndWait(ContractId, spawnerSigner, args, 10).getInstance();
        this.bc = bc;
        this.value = value;
    }

    private ValueInstance(ByzCoinRPC bc, Instance instance) throws CothorityNotFoundException {
        if (!instance.getContractId().equals(ContractId)) {
            logger.error("wrong contractId: {}", (Object)instance.getContractId());
            throw new CothorityNotFoundException("this is not a value instance");
        }
        this.bc = bc;
        this.instance = instance;
        this.value = instance.getData();
    }

    public void update() throws CothorityException {
        this.instance = Instance.fromByzcoin(this.bc, this.instance.getId());
        this.value = this.instance.getData();
    }

    public Instruction evolveValueInstruction(byte[] newValue, Signer owner, int pos, int len) throws CothorityCryptoException {
        Invoke inv = new Invoke("update", ContractId, newValue);
        Instruction inst = new Instruction(this.instance.getId(), Instruction.genNonce(), pos, len, inv);
        try {
            Request r = new Request(this.instance.getDarcId(), "invoke:update", inst.hash(), Arrays.asList(owner.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(owner.sign(r.hash()), owner.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public void evolveValue(byte[] newValue, Signer owner) throws CothorityException {
        Instruction inst = this.evolveValueInstruction(newValue, owner, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.bc.sendTransaction(ct);
    }

    public void evolveValueAndWait(byte[] newValue, Signer owner, int wait) throws CothorityException {
        Instruction inst = this.evolveValueInstruction(newValue, owner, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.bc.sendTransactionAndWait(ct, wait);
        this.value = newValue;
    }

    public InstanceId getId() {
        return this.instance.getId();
    }

    public byte[] getValue() throws CothorityCryptoException {
        byte[] v = new byte[this.value.length];
        System.arraycopy(this.value, 0, v, 0, this.value.length);
        return v;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static ValueInstance fromByzcoin(ByzCoinRPC bc, InstanceId id) throws CothorityException {
        return new ValueInstance(bc, Instance.fromByzcoin(bc, id));
    }

    public static ValueInstance fromByzcoin(ByzCoinRPC bc, Proof p) throws CothorityException {
        return ValueInstance.fromByzcoin(bc, new InstanceId(p.getKey()));
    }
}

