/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import com.google.protobuf.ByteString;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Encryption {
    public static String algo = "AES/CBC/PKCS5Padding";
    public static String algoKey = "AES";
    public static int ivLength = 16;

    public static byte[] encryptData(byte[] data, byte[] keyMaterial) throws CothorityCryptoException {
        keyIv key = new keyIv(keyMaterial);
        try {
            Cipher cipher = Cipher.getInstance(algo);
            SecretKeySpec secKey = new SecretKeySpec(key.symmetricKey, algoKey);
            cipher.init(1, (Key)secKey, key.ivSpec);
            return cipher.doFinal(data);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public static byte[] decryptData(byte[] dataEnc, byte[] keyMaterial) throws CothorityCryptoException {
        keyIv key = new keyIv(keyMaterial);
        try {
            Cipher cipher = Cipher.getInstance(algo);
            cipher.init(2, (Key)key.keySpec, key.ivSpec);
            return cipher.doFinal(dataEnc);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public static byte[] decryptData(ByteString dataEnc, byte[] keyMaterial) throws CothorityCryptoException {
        return Encryption.decryptData(dataEnc.toByteArray(), keyMaterial);
    }

    public static class keyIv {
        public byte[] symmetricKey;
        public byte[] iv;
        public IvParameterSpec ivSpec;
        public SecretKeySpec keySpec;

        public keyIv(byte[] keyMaterial) throws CothorityCryptoException {
            int symmetricLength = keyMaterial.length - ivLength;
            if (symmetricLength <= 0) {
                throw new CothorityCryptoException("too short symmetricKey material");
            }
            this.iv = new byte[ivLength];
            System.arraycopy(keyMaterial, 0, this.iv, 0, ivLength);
            this.ivSpec = new IvParameterSpec(this.iv);
            this.symmetricKey = new byte[keyMaterial.length - ivLength];
            this.keySpec = new SecretKeySpec(this.symmetricKey, algoKey);
        }

        public keyIv(int keylength) {
            this.symmetricKey = new byte[keylength];
            this.iv = new byte[ivLength];
            new SecureRandom().nextBytes(this.symmetricKey);
            new SecureRandom().nextBytes(this.iv);
            this.ivSpec = new IvParameterSpec(this.iv);
            this.keySpec = new SecretKeySpec(this.symmetricKey, algoKey);
        }

        public byte[] getKeyMaterial() {
            byte[] keyMaterial = new byte[ivLength + this.symmetricKey.length];
            System.arraycopy(this.iv, 0, keyMaterial, 0, ivLength);
            System.arraycopy(this.symmetricKey, 0, keyMaterial, ivLength, this.symmetricKey.length);
            return keyMaterial;
        }
    }
}

