/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.Calypso;

public class LTS {
    private LTSId ltsId;
    private Point X;

    public LTS(Calypso.CreateLTSReply reply) {
        try {
            this.ltsId = new LTSId(reply.getLtsid());
        }
        catch (CothorityCryptoException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.X = new Ed25519Point(reply.getX());
    }

    public LTS(LTSId id, Point X) {
        this.ltsId = id;
        this.X = X;
    }

    public LTSId getLtsId() {
        return this.ltsId;
    }

    public Point getX() {
        return this.X;
    }
}

