/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.darc.SignerX509EC;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.DarcProto;
import com.google.protobuf.ByteString;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;

public class IdentityX509EC
implements Identity {
    private final PublicKey pubKey;

    public IdentityX509EC(DarcProto.IdentityX509EC proto) throws CothorityCryptoException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(proto.getPublic().toByteArray());
            this.pubKey = keyFactory.generatePublic(pubSpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CothorityCryptoException("Unable to deserialise IdentityX509EC identity", e);
        }
    }

    public IdentityX509EC(Signer signer) throws CothorityCryptoException {
        if (!SignerX509EC.class.isInstance(signer)) {
            throw new CothorityCryptoException("Wrong signer type: " + signer.toString());
        }
        this.pubKey = ((SignerX509EC)signer).getPublicKey();
    }

    @Override
    public boolean verify(byte[] msg, byte[] signature) {
        try {
            Signature signature2 = Signature.getInstance("SHA384withECDSA");
            signature2.initVerify(this.pubKey);
            signature2.update(msg);
            return signature2.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            return false;
        }
    }

    @Override
    public DarcProto.Identity toProto() {
        DarcProto.Identity.Builder bid = DarcProto.Identity.newBuilder();
        DarcProto.IdentityX509EC.Builder bed = DarcProto.IdentityX509EC.newBuilder();
        bed.setPublic(ByteString.copyFrom((byte[])this.pubKey.getEncoded()));
        bid.setX509Ec(bed);
        return bid.build();
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.typeString(), Hex.printHexBinary(this.pubKey.getEncoded()).toLowerCase());
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof IdentityX509EC)) {
            return false;
        }
        IdentityX509EC otherEd = (IdentityX509EC)other;
        return Arrays.equals(this.pubKey.getEncoded(), otherEd.pubKey.getEncoded());
    }

    @Override
    public String typeString() {
        return "x509ec";
    }
}

