/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.CollectionProto;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import ch.epfl.dedis.skipchain.ForwardLink;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Proof {
    private ByzCoinProto.Proof proof;
    private CollectionProto.Dump leaf;
    private List<ForwardLink> links;

    public Proof(ByzCoinProto.Proof p) {
        this.proof = p;
        List<CollectionProto.Step> steps = p.getInclusionproof().getStepsList();
        CollectionProto.Dump left = steps.get(steps.size() - 1).getLeft();
        CollectionProto.Dump right = steps.get(steps.size() - 1).getRight();
        if (Arrays.equals(left.getKey().toByteArray(), this.getKey())) {
            this.leaf = left;
        } else if (Arrays.equals(right.getKey().toByteArray(), this.getKey())) {
            this.leaf = right;
        }
        this.links = new ArrayList<ForwardLink>();
        for (SkipchainProto.ForwardLink fl : p.getLinksList()) {
            this.links.add(new ForwardLink(fl));
        }
    }

    public Instance getInstance() throws CothorityNotFoundException {
        return Instance.fromProof(this);
    }

    public ByzCoinProto.Proof toProto() {
        return this.proof;
    }

    public SkipBlock getLatest() {
        return new SkipBlock(this.proof.getLatest());
    }

    public boolean verify(SkipblockId id) throws CothorityException {
        return this.isByzCoinProof();
    }

    public boolean matches() {
        return this.leaf != null;
    }

    public byte[] getKey() {
        return this.proof.getInclusionproof().getKey().toByteArray();
    }

    public List<byte[]> getValues() {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (ByteString v : this.leaf.getValuesList()) {
            ret.add(v.toByteArray());
        }
        return ret;
    }

    public byte[] getValue() {
        return this.getValues().get(0);
    }

    public String getContractID() {
        return new String(this.getValues().get(1));
    }

    public DarcId getDarcID() throws CothorityCryptoException {
        return new DarcId(this.getValues().get(2));
    }

    public boolean isByzCoinProof() {
        if (!this.matches()) {
            return false;
        }
        return this.getValues().size() == 3;
    }

    public boolean isContract(String expected) {
        if (!this.isByzCoinProof()) {
            return false;
        }
        String contract = new String(this.getValues().get(1));
        return contract.equals(expected);
    }

    public boolean isContract(String expected, SkipblockId id) throws CothorityException {
        if (!this.verify(id)) {
            return false;
        }
        return this.isContract(expected);
    }
}

