/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.contracts;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.ClientTransactionId;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Request;
import ch.epfl.dedis.lib.darc.Signature;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarcInstance {
    public static String ContractId = "darc";
    private Instance instance;
    private Darc darc;
    private ByzCoinRPC bc;
    private static final Logger logger = LoggerFactory.getLogger(DarcInstance.class);

    public DarcInstance(ByzCoinRPC bc, DarcId spawnerDarcId, Signer spawnerSigner, Darc newDarc) throws CothorityException {
        DarcInstance spawner = DarcInstance.fromByzCoin(bc, spawnerDarcId);
        DarcInstance newDarcInst = spawner.spawnDarcAndWait(newDarc, spawnerSigner, 10);
        this.bc = bc;
        this.darc = newDarc;
        this.instance = newDarcInst.getInstance();
    }

    private DarcInstance(ByzCoinRPC bc, Instance inst) throws CothorityException {
        this.bc = bc;
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contract: {}", (Object)this.instance.getContractId());
            throw new CothorityNotFoundException("this is not a darc contract");
        }
        this.instance = inst;
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public void update() throws CothorityException {
        this.instance = Instance.fromByzcoin(this.bc, this.instance.getId());
        try {
            this.darc = new Darc(this.instance.getData());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public Instruction evolveDarcInstruction(Darc newDarc, Signer owner, int pos, int len) throws CothorityCryptoException {
        newDarc.increaseVersion();
        newDarc.setPrevId(this.darc);
        newDarc.setBaseId(this.darc.getBaseId());
        if (!newDarc.getBaseId().equals(this.darc.getBaseId())) {
            throw new CothorityCryptoException("not darc with same baseID");
        }
        if (newDarc.getVersion() != this.darc.getVersion() + 1L) {
            throw new CothorityCryptoException("not darc with next version");
        }
        Invoke inv = new Invoke("evolve", ContractId, newDarc.toProto().toByteArray());
        byte[] d = newDarc.getBaseId().getId();
        Instruction inst = new Instruction(new InstanceId(d), Instruction.genNonce(), pos, len, inv);
        try {
            Request r = new Request(this.darc.getBaseId(), "invoke:evolve", inst.hash(), Arrays.asList(owner.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(owner.sign(r.hash()), owner.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public void evolveDarc(Darc newDarc, Signer owner) throws CothorityException {
        this.evolveDarcAndWait(newDarc, owner, 0);
    }

    public ClientTransactionId evolveDarcAndWait(Darc newDarc, Signer owner, int wait) throws CothorityException {
        Instruction inst = this.evolveDarcInstruction(newDarc, owner, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        return this.bc.sendTransactionAndWait(ct, wait);
    }

    public Instruction spawnInstanceInstruction(String contractID, Signer s, List<Argument> args, int pos, int len) throws CothorityCryptoException {
        Spawn sp = new Spawn(contractID, args);
        Instruction inst = new Instruction(new InstanceId(this.darc.getBaseId().getId()), Instruction.genNonce(), pos, len, sp);
        try {
            Request r = new Request(this.darc.getBaseId(), "spawn:" + contractID, inst.hash(), Arrays.asList(s.getIdentity()), null);
            logger.info("Signing: {}", (Object)Hex.printHexBinary(r.hash()));
            Signature sign = new Signature(s.sign(r.hash()), s.getIdentity());
            inst.setSignatures(Arrays.asList(sign));
        }
        catch (Signer.SignRequestRejectedException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
        return inst;
    }

    public ClientTransactionId spawnInstance(String contractID, Signer s, List<Argument> args) throws CothorityException {
        Instruction inst = this.spawnInstanceInstruction(contractID, s, args, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        return this.bc.sendTransaction(ct);
    }

    public Proof spawnInstanceAndWait(String contractID, Signer s, List<Argument> args, int wait) throws CothorityException {
        Instruction inst = this.spawnInstanceInstruction(contractID, s, args, 0, 1);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        this.bc.sendTransactionAndWait(ct, wait);
        InstanceId iid = inst.deriveId("");
        if (contractID.equals(ContractId)) {
            try {
                Darc d = new Darc(args.get(0).getValue());
                iid = new InstanceId(d.getBaseId().getId());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CothorityCommunicationException("this is not a correct darc-spawn");
            }
        }
        return this.bc.getProof(iid);
    }

    public DarcInstance spawnDarcAndWait(Darc d, Signer s, int wait) throws CothorityException {
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("darc", d.toProto().toByteArray()));
        if (wait > 0) {
            Proof p = this.spawnInstanceAndWait(ContractId, s, args, wait);
            return new DarcInstance(this.bc, p.getInstance());
        }
        this.spawnInstance(ContractId, s, args);
        return null;
    }

    public DarcId getId() throws CothorityCryptoException {
        return this.darc.getId();
    }

    public Darc getDarc() throws CothorityCryptoException {
        return this.darc.copy();
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, InstanceId id) throws CothorityException {
        return new DarcInstance(bc, Instance.fromByzcoin(bc, id));
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, DarcId baseId) throws CothorityException {
        return DarcInstance.fromByzCoin(bc, new InstanceId(baseId.getId()));
    }

    public static DarcInstance fromByzCoin(ByzCoinRPC bc, Darc d) throws CothorityException {
        return DarcInstance.fromByzCoin(bc, d.getBaseId());
    }
}

