/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.transaction;

import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import java.util.ArrayList;
import java.util.List;

public class Spawn {
    private String contractId;
    private List<Argument> arguments;

    public Spawn(String contractId, List<Argument> arguments) {
        this.contractId = contractId;
        this.arguments = arguments;
    }

    public Spawn(ByzCoinProto.Spawn proto) {
        this.contractId = proto.getContractid();
        this.arguments = new ArrayList<Argument>();
        for (ByzCoinProto.Argument a : proto.getArgsList()) {
            this.arguments.add(new Argument(a));
        }
    }

    public String getContractId() {
        return this.contractId;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public ByzCoinProto.Spawn toProto() {
        ByzCoinProto.Spawn.Builder b = ByzCoinProto.Spawn.newBuilder();
        b.setContractid(this.contractId);
        for (Argument a : this.arguments) {
            b.addArgs(a.toProto());
        }
        return b.build();
    }
}

