/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.calypso.DecryptKeyReply;
import ch.epfl.dedis.calypso.LTS;
import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.proto.Calypso;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalypsoRPC
extends ByzCoinRPC {
    private LTS lts;
    private final Logger logger = LoggerFactory.getLogger(CalypsoRPC.class);

    public CalypsoRPC(ByzCoinRPC byzcoin) throws CothorityException {
        super(byzcoin);
        this.lts = this.createLTS();
    }

    public CalypsoRPC(Roster roster, Darc genesis, Duration blockInterval) throws CothorityException {
        super(roster, genesis, blockInterval);
        this.lts = this.createLTS();
    }

    private CalypsoRPC(ByzCoinRPC bc, LTSId ltsId) throws CothorityCommunicationException {
        super(bc);
        Point X = this.getSharedPublicKey(ltsId);
        this.lts = new LTS(ltsId, X);
    }

    public Point getSharedPublicKey(LTSId ltsId) throws CothorityCommunicationException {
        Calypso.SharedPublic.Builder request = Calypso.SharedPublic.newBuilder();
        request.setLtsid(ltsId.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/SharedPublic", request.build());
        try {
            Calypso.SharedPublicReply reply = Calypso.SharedPublicReply.parseFrom(msg);
            return new Ed25519Point(reply.getX());
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public LTS createLTS() throws CothorityCommunicationException {
        Calypso.CreateLTS.Builder b = Calypso.CreateLTS.newBuilder();
        b.setRoster(this.getRoster().toProto());
        b.setBcid(this.getGenesisBlock().getId().toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/CreateLTS", b.build());
        try {
            Calypso.CreateLTSReply resp = Calypso.CreateLTSReply.parseFrom(msg);
            return new LTS(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public DecryptKeyReply tryDecrypt(Proof writeProof, Proof readProof) throws CothorityCommunicationException {
        Calypso.DecryptKey.Builder b = Calypso.DecryptKey.newBuilder();
        b.setRead(readProof.toProto());
        b.setWrite(writeProof.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/DecryptKey", b.build());
        try {
            Calypso.DecryptKeyReply resp = Calypso.DecryptKeyReply.parseFrom(msg);
            return new DecryptKeyReply(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public LTSId getLTSId() {
        return this.lts.getLtsId();
    }

    public Point getLTSX() {
        return this.lts.getX();
    }

    public LTS getLTS() {
        return this.lts;
    }

    public static CalypsoRPC fromCalypso(Roster roster, SkipblockId byzcoinId, LTSId ltsId) throws CothorityException {
        return new CalypsoRPC(ByzCoinRPC.fromByzCoin(roster, byzcoinId), ltsId);
    }
}

