/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.Encryption;
import ch.epfl.dedis.calypso.LTS;
import ch.epfl.dedis.calypso.ReadInstance;
import ch.epfl.dedis.calypso.WriteData;
import ch.epfl.dedis.calypso.WriteInstance;
import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.Arrays;

public class Document {
    private byte[] data;
    private byte[] keyMaterial;
    private byte[] extraData;
    private DarcId publisherId;

    public Document(byte[] data, byte[] keyMaterial, byte[] extraData, DarcId publisherId) throws CothorityCryptoException {
        this.data = data;
        this.keyMaterial = keyMaterial;
        this.publisherId = publisherId;
        this.extraData = extraData;
    }

    public Document(byte[] data, int keylen, byte[] extraData, DarcId publisherId) throws CothorityCryptoException {
        this(data, new Encryption.keyIv(keylen).getKeyMaterial(), extraData, publisherId);
    }

    public WriteData getWriteData(LTS lts) throws CothorityException {
        return new WriteData(lts, Encryption.encryptData(this.data, this.keyMaterial), this.keyMaterial, this.extraData, this.publisherId);
    }

    public WriteInstance spawnWrite(CalypsoRPC calypso, DarcId publisherDarcId, Signer publisherSigner) throws CothorityException {
        return new WriteInstance(calypso, publisherDarcId, Arrays.asList(publisherSigner), this.getWriteData(calypso.getLTS()));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Document)) {
            return false;
        }
        Document otherDoc = (Document)other;
        boolean wrid = true;
        return Arrays.equals(otherDoc.data, this.data) && Arrays.equals(otherDoc.extraData, this.extraData) && Arrays.equals(otherDoc.keyMaterial, this.keyMaterial) && otherDoc.publisherId.equals(this.publisherId) && wrid;
    }

    public byte[] getKeyMaterial() {
        return this.keyMaterial;
    }

    public byte[] getExtraData() {
        return this.extraData;
    }

    public DarcId getPublisherId() {
        return this.publisherId;
    }

    public byte[] getData() throws CothorityCryptoException {
        return this.data;
    }

    public String toString() {
        String wrid = "null";
        return String.format("data: %s\nextraData: %s\nkeyMaterial: %s\npublisherId: %s\nwriteRequestId: %s", Hex.printHexBinary(this.data), Hex.printHexBinary(this.extraData), Hex.printHexBinary(this.keyMaterial), this.publisherId.toString(), wrid);
    }

    public static Document fromCalypso(CalypsoRPC calypso, InstanceId riId, Scalar reader) throws CothorityException {
        ReadInstance ri = ReadInstance.fromByzCoin(calypso, riId);
        WriteInstance wi = WriteInstance.fromCalypso(calypso, ri.getRead().getWriteId());
        byte[] keyMaterial = ri.decryptKeyMaterial(reader);
        return Document.fromWriteInstance(wi, keyMaterial);
    }

    public static Document fromWriteInstance(WriteInstance wi, byte[] keyMaterial) throws CothorityNotFoundException, CothorityCryptoException {
        byte[] data = Encryption.decryptData(wi.getWrite().getDataEnc(), keyMaterial);
        return new Document(data, keyMaterial, wi.getWrite().getExtraData(), wi.getDarcId());
    }
}

