/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib.darc;

import ch.epfl.dedis.lib.darc.Rule;
import ch.epfl.dedis.lib.exception.CothorityAlreadyExistsException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.DarcProto;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class Rules {
    public static final String OR = " | ";
    public static final String AND = " & ";
    private List<Rule> list;

    public Rules() {
        this.list = new ArrayList<Rule>();
    }

    public Rules(Rules other) {
        ArrayList<Rule> newList = new ArrayList<Rule>(other.list.size());
        newList.addAll(other.list);
        this.list = newList;
    }

    public Rules(DarcProto.Rules rules) {
        this.list = new ArrayList<Rule>();
        for (DarcProto.Rule protoRule : rules.getListList()) {
            Rule r = new Rule(protoRule.getAction(), protoRule.getExpr().toByteArray());
            this.list.add(r);
        }
    }

    public void addRule(String a, byte[] expr) throws CothorityAlreadyExistsException {
        if (this.exists(a) != -1) {
            throw new CothorityAlreadyExistsException("rule already exists");
        }
        this.list.add(new Rule(a, expr));
    }

    public void updateRule(String a, byte[] expr) throws CothorityNotFoundException {
        int i = this.exists(a);
        if (i == -1) {
            throw new CothorityNotFoundException("cannot update a non-existing rule");
        }
        this.list.set(i, new Rule(a, expr));
    }

    public Rule get(String a) {
        for (Rule rule : this.list) {
            if (!rule.getAction().equals(a)) continue;
            return rule;
        }
        return null;
    }

    public List<Rule> getAllRules() {
        return this.list;
    }

    public List<String> getAllActions() {
        return this.list.stream().map(Rule::getAction).collect(Collectors.toList());
    }

    public Rule remove(String a) {
        int i = this.exists(a);
        if (i == -1) {
            return null;
        }
        return this.list.remove(i);
    }

    public boolean contains(String a) {
        return this.exists(a) != -1;
    }

    public DarcProto.Rules toProto() {
        DarcProto.Rules.Builder b = DarcProto.Rules.newBuilder();
        for (Rule rule : this.list) {
            b.addList(rule.toProto());
        }
        return b.build();
    }

    private int exists(String a) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).getAction().equals(a)) continue;
            return i;
        }
        return -1;
    }
}

