/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.DataBody;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.TxResult;
import ch.epfl.dedis.lib.Sha256id;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class Block {
    private ByzCoinProto.DataHeader dataHeader;
    private DataBody dataBody;
    private SkipblockId sbId;

    public Block(SkipBlock sb) throws CothorityCryptoException {
        try {
            this.dataHeader = ByzCoinProto.DataHeader.parseFrom(sb.getData());
            this.dataBody = new DataBody(ByzCoinProto.DataBody.parseFrom(sb.getPayload()));
            this.sbId = sb.getId();
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public Block(Proof p) throws CothorityCryptoException {
        SkipBlock sb = p.getLatest();
        try {
            this.dataHeader = ByzCoinProto.DataHeader.parseFrom(sb.getData());
            this.dataBody = new DataBody(ByzCoinProto.DataBody.parseFrom(sb.getPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCryptoException(e.getMessage());
        }
    }

    public Sha256id getTrieRoot() throws CothorityCryptoException {
        return new Sha256id(this.dataHeader.getTrieroot());
    }

    public Sha256id getClientTransactionHash() throws CothorityCryptoException {
        return new Sha256id(this.dataHeader.getClienttransactionhash());
    }

    public Sha256id getStateChangesHash() throws CothorityCryptoException {
        return new Sha256id(this.dataHeader.getStatechangeshash());
    }

    public List<ClientTransaction> getAcceptedClientTransactions() {
        ArrayList<ClientTransaction> result = new ArrayList<ClientTransaction>();
        this.dataBody.getTxResults().forEach(txr -> {
            if (txr.isAccepted()) {
                result.add(txr.getClientTransaction());
            }
        });
        return result;
    }

    public long getTimestampNano() {
        return this.dataHeader.getTimestamp();
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.getTimestampNano() / 1000L / 1000L);
    }

    public List<TxResult> getTxResults() {
        return this.dataBody.getTxResults();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return super.equals(obj);
        }
        Block other = (Block)obj;
        return other.sbId.equals(this.sbId);
    }
}

