/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.StateChangeBody;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import ch.epfl.dedis.lib.proto.TrieProto;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;

public class Proof {
    private TrieProto.Proof proof;
    private List<SkipchainProto.ForwardLink> links;
    private SkipBlock latest;
    private StateChangeBody finalStateChangeBody;

    public Proof(ByzCoinProto.Proof p) throws InvalidProtocolBufferException {
        this.proof = p.getInclusionproof();
        this.latest = new SkipBlock(p.getLatest());
        this.links = p.getLinksList();
        if (!this.proof.getLeaf().getKey().isEmpty()) {
            this.finalStateChangeBody = new StateChangeBody(ByzCoinProto.StateChangeBody.parseFrom(this.proof.getLeaf().getValue()));
        }
    }

    public Instance getInstance() throws CothorityNotFoundException {
        return Instance.fromProof(this);
    }

    public ByzCoinProto.Proof toProto() {
        ByzCoinProto.Proof.Builder b = ByzCoinProto.Proof.newBuilder();
        b.setInclusionproof(this.proof);
        b.setLatest(this.latest.getProto());
        for (SkipchainProto.ForwardLink link : this.links) {
            b.addLinks(link);
        }
        return b.build();
    }

    public SkipBlock getLatest() {
        return this.latest;
    }

    public boolean verify(SkipblockId id) throws CothorityException {
        return this.isByzCoinProof();
    }

    public boolean matches() {
        return this.proof.getLeaf().hasKey() && !this.proof.getLeaf().getKey().isEmpty();
    }

    public byte[] getKey() {
        return this.proof.getLeaf().getKey().toByteArray();
    }

    public StateChangeBody getValues() {
        return this.finalStateChangeBody;
    }

    public byte[] getValue() {
        return this.getValues().getValue();
    }

    public String getContractID() {
        return new String(this.getValues().getContractID());
    }

    public DarcId getDarcID() throws CothorityCryptoException {
        return this.getValues().getDarcId();
    }

    public boolean isByzCoinProof() {
        return this.matches();
    }

    public boolean isContract(String expected) {
        if (!this.isByzCoinProof()) {
            return false;
        }
        return this.getContractID().equals(expected);
    }

    public boolean isContract(String expected, SkipblockId id) throws CothorityException {
        if (!this.verify(id)) {
            return false;
        }
        return this.isContract(expected);
    }
}

