/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.transaction;

import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.Delete;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Identity;
import ch.epfl.dedis.lib.darc.Request;
import ch.epfl.dedis.lib.darc.Signature;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.DarcProto;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class Instruction {
    private InstanceId instId;
    private byte[] nonce;
    private int index;
    private int length;
    private Spawn spawn;
    private Invoke invoke;
    private Delete delete;
    private List<Signature> signatures;

    public Instruction(InstanceId instId, byte[] nonce, int index, int length, Spawn spawn) {
        this.instId = instId;
        this.nonce = nonce;
        this.index = index;
        this.length = length;
        this.spawn = spawn;
    }

    public Instruction(InstanceId instId, byte[] nonce, int index, int length, Invoke invoke) {
        this.instId = instId;
        this.nonce = nonce;
        this.index = index;
        this.length = length;
        this.invoke = invoke;
    }

    public Instruction(InstanceId instId, byte[] nonce, int index, int length, Delete delete) {
        this.instId = instId;
        this.nonce = nonce;
        this.index = index;
        this.length = length;
        this.delete = delete;
    }

    public Instruction(ByzCoinProto.Instruction inst) throws CothorityCryptoException {
        this.instId = new InstanceId(inst.getInstanceid());
        this.nonce = inst.getNonce().toByteArray();
        this.index = inst.getIndex();
        this.length = inst.getLength();
        if (inst.hasSpawn()) {
            this.spawn = new Spawn(inst.getSpawn());
        }
        if (inst.hasInvoke()) {
            this.invoke = new Invoke(inst.getInvoke());
        }
        if (inst.hasDelete()) {
            this.delete = new Delete(inst.getDelete());
        }
        this.signatures = new ArrayList<Signature>();
        for (DarcProto.Signature sig : inst.getSignaturesList()) {
            this.signatures.add(new Signature(sig));
        }
    }

    public InstanceId getInstId() {
        return this.instId;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public byte[] hash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.instId.getId());
            digest.update(this.nonce);
            digest.update(Instruction.intToArr4(this.index));
            digest.update(Instruction.intToArr4(this.length));
            List<Object> args = new ArrayList();
            if (this.spawn != null) {
                digest.update((byte)0);
                digest.update(this.spawn.getContractId().getBytes());
                args = this.spawn.getArguments();
            } else if (this.invoke != null) {
                digest.update((byte)1);
                args = this.invoke.getArguments();
            } else if (this.delete != null) {
                digest.update((byte)2);
            }
            for (Argument a : args) {
                digest.update(a.getName().getBytes());
                digest.update(a.getValue());
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ByzCoinProto.Instruction toProto() {
        ByzCoinProto.Instruction.Builder b = ByzCoinProto.Instruction.newBuilder();
        b.setInstanceid(ByteString.copyFrom((byte[])this.instId.getId()));
        b.setNonce(ByteString.copyFrom((byte[])this.nonce));
        b.setIndex(this.index);
        b.setLength(this.length);
        if (this.spawn != null) {
            b.setSpawn(this.spawn.toProto());
        } else if (this.invoke != null) {
            b.setInvoke(this.invoke.toProto());
        } else if (this.delete != null) {
            b.setDelete(this.delete.toProto());
        }
        for (Signature s : this.signatures) {
            b.addSignatures(s.toProto());
        }
        return b.build();
    }

    public String action() {
        String a = "invalid";
        if (this.spawn != null) {
            a = "spawn:" + this.spawn.getContractId();
        } else if (this.invoke != null) {
            a = "invoke:" + this.invoke.getCommand();
        } else if (this.delete != null) {
            a = "delete";
        }
        return a;
    }

    public Request toDarcRequest(DarcId darcId) {
        ArrayList<Identity> ids = new ArrayList<Identity>();
        ArrayList<byte[]> sigs = new ArrayList<byte[]>();
        for (Signature sig : this.signatures) {
            ids.add(sig.signer);
            sigs.add(sig.signature);
        }
        return new Request(darcId, this.action(), this.hash(), ids, sigs);
    }

    public void signBy(DarcId darcId, List<Signer> signers) throws CothorityCryptoException {
        this.signatures = new ArrayList<Signature>();
        for (Signer signer : signers) {
            this.signatures.add(new Signature(null, signer.getIdentity()));
        }
        byte[] msg = this.toDarcRequest(darcId).hash();
        for (int i = 0; i < this.signatures.size(); ++i) {
            try {
                this.signatures.set(i, new Signature(signers.get(i).sign(msg), signers.get(i).getIdentity()));
                continue;
            }
            catch (Signer.SignRequestRejectedException e) {
                throw new CothorityCryptoException(e.getMessage());
            }
        }
    }

    public InstanceId deriveId(String what) throws CothorityCryptoException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.hash());
            digest.update(Instruction.intToArr4(this.signatures.size()));
            for (Signature sig : this.signatures) {
                digest.update(Instruction.intToArr4(sig.signature.length));
                digest.update(sig.signature);
            }
            digest.update(what.getBytes());
            return new InstanceId(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    public Spawn getSpawn() {
        return this.spawn;
    }

    public Invoke getInvoke() {
        return this.invoke;
    }

    public Delete getDelete() {
        return this.delete;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public static byte[] genNonce() {
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[32];
        sr.nextBytes(nonce);
        return nonce;
    }

    private static byte[] intToArr4(int x) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.putInt(x);
        return b.array();
    }
}

