/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzgen;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityException;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalypsoFactory {
    private ArrayList<ServerIdentity> servers = new ArrayList();
    private SkipblockId genesis;
    private LTSId ltsId;
    private static final Logger logger = LoggerFactory.getLogger(CalypsoFactory.class);

    public CalypsoFactory setGenesis(SkipblockId genesis) {
        this.genesis = genesis;
        return this;
    }

    public CalypsoFactory setLTSId(LTSId ltsId) {
        this.ltsId = ltsId;
        return this;
    }

    public CalypsoFactory addConode(URI conode, String publicKey) {
        if (!conode.getScheme().equals("tcp")) {
            throw new IllegalArgumentException("conode address must be in tcp format like \"tcp://127.0.0.0:7001\"");
        }
        this.servers.add(new ServerIdentity(conode, publicKey));
        return this;
    }

    public CalypsoFactory addConode(ConodeAddress conode) {
        return this.addConode(conode.getAddress(), conode.getPublicKey());
    }

    public CalypsoFactory addConodes(Collection<ConodeAddress> conodes) {
        for (ConodeAddress conodeAddress : conodes) {
            this.addConode(conodeAddress);
        }
        return this;
    }

    public CalypsoRPC createConnection() throws CothorityException {
        if (null == this.genesis) {
            throw new IllegalStateException("Connection can not be established. No genesis specified.");
        }
        if (null == this.ltsId) {
            throw new IllegalStateException("Connection can not be established. No ltsId specified.");
        }
        return CalypsoRPC.fromCalypso(this.createRoster(), this.genesis, this.ltsId);
    }

    public CalypsoRPC initialiseNewCalypso(Signer admin) throws CothorityException {
        Roster roster = this.createRoster();
        Darc adminDarc = ByzCoinRPC.makeGenesisDarc(admin, roster);
        return new CalypsoRPC(roster, adminDarc, Duration.ofMillis(500L));
    }

    private Roster createRoster() {
        if (this.servers.size() < 1) {
            throw new IllegalStateException("Connection can not be established. No cothority server was specified.");
        }
        return new Roster(this.servers);
    }

    public static class ConodeAddress {
        private final URI address;
        private final String publicKey;

        public URI getAddress() {
            return this.address;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public ConodeAddress(URI address, String publicKey) {
            this.address = address;
            this.publicKey = publicKey;
        }
    }
}

