/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.Calypso;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DecryptKeyReply {
    private List<Point> Cs;
    private Point XhatEnc;
    private Point X;

    public DecryptKeyReply(Calypso.DecryptKeyReply proto) {
        this.Cs = proto.getCsList().stream().map(Ed25519Point::new).collect(Collectors.toList());
        this.XhatEnc = new Ed25519Point(proto.getXhatenc());
        this.X = new Ed25519Point(proto.getX());
    }

    public byte[] getKeyMaterial(Scalar reader) throws CothorityCryptoException {
        Scalar xc = reader.reduce();
        Scalar xcInv = xc.negate();
        Point XhatDec = this.X.mul(xcInv);
        Point Xhat = this.XhatEnc.add(XhatDec);
        Point XhatInv = Xhat.negate();
        byte[] keyMaterial = "".getBytes();
        for (Point C : this.Cs) {
            Point keyPointHat = C.add(XhatInv);
            byte[] keyPart = keyPointHat.data();
            int lastpos = keyMaterial.length;
            keyMaterial = Arrays.copyOfRange(keyMaterial, 0, keyMaterial.length + keyPart.length);
            System.arraycopy(keyPart, 0, keyMaterial, lastpos, keyPart.length);
        }
        return keyMaterial;
    }
}

