/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.LTS;
import ch.epfl.dedis.calypso.ReadInstance;
import ch.epfl.dedis.calypso.WriteData;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteInstance {
    public static String ContractId = "calypsoWrite";
    private Instance instance;
    private CalypsoRPC calypso;
    private LTS lts;
    private static final Logger logger = LoggerFactory.getLogger(WriteInstance.class);

    public WriteInstance(CalypsoRPC calypso, DarcId darcId, List<Signer> signers, WriteData wr) throws CothorityException {
        this.calypso = calypso;
        this.lts = calypso.getLTS();
        InstanceId id = this.spawnCalypsoWrite(wr, darcId, signers);
        this.instance = this.getInstance(id);
    }

    private WriteInstance(CalypsoRPC calypso, InstanceId id) throws CothorityException {
        this.calypso = calypso;
        this.instance = this.getInstance(id);
        this.lts = calypso.getLTS();
    }

    public LTS getLts() {
        return this.lts;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public DarcId getDarcId() {
        return this.instance.getDarcId();
    }

    public WriteData getWrite() throws CothorityNotFoundException {
        return WriteData.fromInstance(this.getInstance());
    }

    public ReadInstance spawnCalypsoRead(CalypsoRPC calypso, List<Signer> readers) throws CothorityException {
        return new ReadInstance(calypso, this, readers);
    }

    public static WriteInstance fromCalypso(CalypsoRPC calypso, InstanceId writeId) throws CothorityException {
        return new WriteInstance(calypso, writeId);
    }

    private InstanceId spawnCalypsoWrite(WriteData req, DarcId darcID, List<Signer> signers) throws CothorityException {
        Argument arg = new Argument("write", req.getWrite().toByteArray());
        Spawn spawn = new Spawn(ContractId, Arrays.asList(arg));
        Instruction instr = new Instruction(new InstanceId(darcID.getId()), Instruction.genNonce(), 0, 1, spawn);
        instr.signBy(darcID, signers);
        ClientTransaction tx = new ClientTransaction(Arrays.asList(instr));
        this.calypso.sendTransactionAndWait(tx, 5);
        return instr.deriveId("");
    }

    private Instance getInstance(InstanceId id) throws CothorityException {
        Instance inst = this.calypso.getProof(id).getInstance();
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contractId: {}", (Object)inst.getContractId());
            throw new CothorityNotFoundException("this is not an " + ContractId + " instance");
        }
        return inst;
    }
}

