/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.Hex;
import ch.epfl.dedis.lib.UUIDType5;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.proto.NetworkProto;
import ch.epfl.dedis.lib.proto.StatusProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.moandjiezana.toml.Toml;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerIdentity {
    private final URI conodeAddress;
    public Point Public;
    private final Logger logger = LoggerFactory.getLogger(ServerIdentity.class);

    public ServerIdentity(URI serverWsAddress, String publicKey) {
        this.conodeAddress = serverWsAddress;
        this.Public = new Ed25519Point(Hex.parseHexBinary(publicKey));
    }

    public ServerIdentity(Toml siToml) throws URISyntaxException {
        this(new URI(siToml.getString("Address")), siToml.getString("Public"));
    }

    public ServerIdentity(NetworkProto.ServerIdentity sid) throws URISyntaxException {
        this(new URI(sid.getAddress()), Hex.printHexBinary(sid.getPublic().toByteArray()));
    }

    public URI getAddress() {
        return this.conodeAddress;
    }

    public StatusProto.Response GetStatus() throws CothorityCommunicationException {
        StatusProto.Request request = StatusProto.Request.newBuilder().build();
        try {
            SyncSendMessage msg = new SyncSendMessage("Status/Request", request.toByteArray());
            return StatusProto.Response.parseFrom(msg.response);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e.toString());
        }
    }

    public NetworkProto.ServerIdentity toProto() {
        NetworkProto.ServerIdentity.Builder si = NetworkProto.ServerIdentity.newBuilder();
        si.setPublic(this.Public.toProto());
        String pubStr = "https://dedis.epfl.ch/id/" + this.Public.toString().toLowerCase();
        byte[] id = UUIDType5.toBytes(UUIDType5.nameUUIDFromNamespaceAndString(UUIDType5.NAMESPACE_URL, pubStr));
        si.setId(ByteString.copyFrom((byte[])id));
        si.setAddress(this.getAddress().toString());
        si.setDescription("");
        return si.build();
    }

    public byte[] SendMessage(String path, byte[] data) throws CothorityCommunicationException {
        SyncSendMessage ssm = new SyncSendMessage(path, data);
        if (ssm.response == null) {
            throw new CothorityCommunicationException("Error while retrieving response - try again. Error-string is: " + ssm.error);
        }
        return ssm.response.array();
    }

    public StreamingConn MakeStreamingConnection(String path, byte[] data, StreamHandler h) throws CothorityCommunicationException {
        return new StreamingConn(path, data, h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerIdentity other = (ServerIdentity)o;
        return other.getAddress().equals(this.getAddress()) && other.Public.equals(this.Public);
    }

    public int hashCode() {
        return Arrays.hashCode(this.Public.toBytes());
    }

    private URI buildWebSocketAdddress(String servicePath) throws URISyntaxException {
        return new URI("ws", this.conodeAddress.getUserInfo(), this.conodeAddress.getHost(), this.conodeAddress.getPort() + 1, servicePath.startsWith("/") ? servicePath : "/".concat(servicePath), this.conodeAddress.getQuery(), this.conodeAddress.getFragment());
    }

    public class SyncSendMessage {
        public ByteBuffer response;
        public String error;

        private SyncSendMessage(String path, final byte[] msg) throws CothorityCommunicationException {
            final CountDownLatch statusLatch = new CountDownLatch(1);
            try {
                WebSocketClient ws = new WebSocketClient(ServerIdentity.this.buildWebSocketAdddress(path)){

                    public void onMessage(String msg2) {
                        SyncSendMessage.this.error = "This should never happen:" + msg2;
                        statusLatch.countDown();
                    }

                    public void onMessage(ByteBuffer message) {
                        SyncSendMessage.this.response = message;
                        this.close();
                        statusLatch.countDown();
                    }

                    public void onOpen(ServerHandshake handshake) {
                        this.send(msg);
                    }

                    public void onClose(int code, String reason, boolean remote) {
                        if (!reason.equals("")) {
                            SyncSendMessage.this.error = reason;
                        }
                        statusLatch.countDown();
                    }

                    public void onError(Exception ex) {
                        SyncSendMessage.this.error = "Error: " + ex.toString();
                        statusLatch.countDown();
                    }
                };
                ws.connect();
                statusLatch.await();
            }
            catch (InterruptedException | URISyntaxException e) {
                throw new CothorityCommunicationException(e.toString());
            }
            if (this.error != null) {
                ServerIdentity.this.logger.error("error: {}", (Object)this.error);
                throw new CothorityCommunicationException(this.error);
            }
        }
    }

    public class StreamingConn {
        private WebSocketClient ws;

        public void close() {
            this.ws.close();
        }

        public boolean isClosed() {
            return this.ws.isClosed();
        }

        private StreamingConn(String path, final byte[] msg, final StreamHandler h) throws CothorityCommunicationException {
            try {
                this.ws = new WebSocketClient(ServerIdentity.this.buildWebSocketAdddress(path)){

                    public void onMessage(String msg2) {
                        ServerIdentity.this.logger.error("received a string msg, this should not happen on an honest server");
                        h.error("received a string msg, this should not happen on an honest server: " + msg2);
                    }

                    public void onMessage(ByteBuffer message) {
                        h.receive(message);
                    }

                    public void onOpen(ServerHandshake handshake) {
                        this.send(msg);
                    }

                    public void onClose(int code, String reason, boolean remote) {
                        if (!reason.equals("")) {
                            h.error(reason);
                        }
                    }

                    public void onError(Exception ex) {
                        h.error(ex.toString());
                    }
                };
                this.ws.connect();
            }
            catch (URISyntaxException e) {
                throw new CothorityCommunicationException(e.getMessage());
            }
        }
    }

    public static interface StreamHandler {
        public void receive(ByteBuffer var1);

        public void error(String var1);
    }
}

