/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.skipchain;

import ch.epfl.dedis.lib.Roster;
import ch.epfl.dedis.lib.ServerIdentity;
import ch.epfl.dedis.lib.SkipBlock;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipchainRPC {
    protected SkipblockId scID;
    protected Roster roster;
    private final Logger logger = LoggerFactory.getLogger(SkipchainRPC.class);

    public SkipchainRPC(Roster roster, SkipblockId scID) throws CothorityCommunicationException {
        this.scID = scID;
        this.roster = roster;
    }

    public boolean verify() {
        boolean ok = true;
        for (ServerIdentity n : this.roster.getNodes()) {
            this.logger.info("Testing node {}", (Object)n.getAddress());
            try {
                n.GetStatus();
            }
            catch (CothorityCommunicationException e) {
                this.logger.warn("Failing node {}", (Object)n.getAddress());
                ok = false;
            }
        }
        return ok;
    }

    public SkipBlock getSkipblock(SkipblockId id) throws CothorityCommunicationException {
        SkipchainProto.GetSingleBlock request = SkipchainProto.GetSingleBlock.newBuilder().setId(ByteString.copyFrom((byte[])id.getId())).build();
        ByteString msg = this.roster.sendMessage("Skipchain/GetSingleBlock", request);
        try {
            SkipchainProto.SkipBlock sb = SkipchainProto.SkipBlock.parseFrom(msg);
            this.logger.debug("Got the following skipblock: {}", (Object)sb);
            this.logger.info("Successfully read skipblock");
            return new SkipBlock(sb);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SkipBlock getLatestSkipblock() throws CothorityCommunicationException {
        SkipchainProto.GetUpdateChain request = SkipchainProto.GetUpdateChain.newBuilder().setLatestID(ByteString.copyFrom((byte[])this.scID.getId())).build();
        ByteString msg = this.roster.sendMessage("Skipchain/GetUpdateChain", request);
        try {
            SkipchainProto.GetUpdateChainReply reply = SkipchainProto.GetUpdateChainReply.parseFrom(msg);
            if (reply.getUpdateCount() == 0) {
                this.logger.info("didn't find any updates to {}", (Object)this.scID);
                return null;
            }
            SkipBlock sb = new SkipBlock(reply.getUpdate(reply.getUpdateCount() - 1));
            this.logger.info("Got the following latest skipblock: {}", (Object)sb);
            return sb;
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SkipblockId getID() {
        return this.scID;
    }

    public Roster getRoster() {
        return this.roster;
    }
}

