/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin;

import ch.epfl.dedis.byzcoin.StateChange;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import com.google.protobuf.ByteString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class StateChanges {
    private List<StateChange> stateChanges = new ArrayList<StateChange>();
    private ByteString hash;

    public StateChanges(List<ByzCoinProto.StateChange> scs) {
        this.hash(scs);
    }

    public StateChange get(int index) {
        return this.stateChanges.get(index);
    }

    public ByteString getHash() {
        return this.hash;
    }

    private void hash(List<ByzCoinProto.StateChange> scs) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return;
        }
        for (ByzCoinProto.StateChange sc : scs) {
            digest.update(sc.toByteArray());
            this.stateChanges.add(new StateChange(sc));
        }
        this.hash = ByteString.copyFrom((byte[])digest.digest());
    }
}

