/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.contracts;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.contracts.ChainConfigData;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainConfigInstance {
    public static String ContractId = "config";
    private Instance instance;
    private ByzCoinRPC bc;
    private ChainConfigData chainConfig;
    private static final Logger logger = LoggerFactory.getLogger(ChainConfigInstance.class);

    private ChainConfigInstance(ByzCoinRPC bc, Instance instance) throws CothorityNotFoundException {
        if (!instance.getContractId().equals(ContractId)) {
            logger.error("wrong contractId: {}", (Object)instance.getContractId());
            throw new CothorityNotFoundException("this is not a value instance");
        }
        this.bc = bc;
        this.instance = instance;
        this.chainConfig = new ChainConfigData(instance);
    }

    public void update() throws CothorityCommunicationException, CothorityNotFoundException {
        this.instance = Instance.fromByzcoin(this.bc, this.instance.getId());
        this.chainConfig = new ChainConfigData(this.instance);
    }

    public Instruction evolveChainConfigInstruction(ChainConfigData newConfig, List<Long> ownerCtrs) {
        Invoke inv = new Invoke("update_config", ContractId, newConfig.toProto().toByteArray());
        return new Instruction(this.instance.getId(), ownerCtrs, inv);
    }

    public void evolveChainConfig(ChainConfigData newConfig, List<Signer> owners, List<Long> ownerCtrs) throws CothorityException {
        Instruction inst = this.evolveChainConfigInstruction(newConfig, ownerCtrs);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        ct.signWith(owners);
        this.bc.sendTransaction(ct);
    }

    public void evolveConfigAndWait(ChainConfigData newConfig, List<Signer> owners, List<Long> ownerCtrs, int wait) throws CothorityException {
        Instruction inst = this.evolveChainConfigInstruction(newConfig, ownerCtrs);
        ClientTransaction ct = new ClientTransaction(Arrays.asList(inst));
        ct.signWith(owners);
        this.bc.sendTransactionAndWait(ct, wait);
        this.chainConfig = newConfig;
    }

    public InstanceId getId() {
        return this.instance.getId();
    }

    public ChainConfigData getChainConfig() {
        return new ChainConfigData(this.chainConfig);
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static ChainConfigInstance fromByzcoin(ByzCoinRPC bc) throws CothorityNotFoundException, CothorityCommunicationException {
        return new ChainConfigInstance(bc, Instance.fromByzcoin(bc, new InstanceId(new byte[32])));
    }

    public static ChainConfigInstance fromByzcoin(ByzCoinRPC bc, Proof p) throws CothorityNotFoundException, CothorityCommunicationException {
        return new ChainConfigInstance(bc, Instance.fromProof(p));
    }
}

