/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzcoin.transaction;

import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.Delete;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.lib.darc.Signature;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.ByzCoinProto;
import ch.epfl.dedis.lib.proto.DarcProto;
import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public class Instruction {
    private InstanceId instId;
    private Spawn spawn;
    private Invoke invoke;
    private Delete delete;
    private List<Long> signerCounters;
    private List<Signature> signatures;

    public Instruction(InstanceId instId, List<Long> ctrs, Spawn spawn) {
        this.instId = instId;
        this.signerCounters = ctrs;
        this.spawn = spawn;
    }

    public Instruction(InstanceId instId, List<Long> ctrs, Invoke invoke) {
        this.instId = instId;
        this.signerCounters = ctrs;
        this.invoke = invoke;
    }

    public Instruction(InstanceId instId, List<Long> ctrs, Delete delete) {
        this.instId = instId;
        this.signerCounters = ctrs;
        this.delete = delete;
    }

    public Instruction(ByzCoinProto.Instruction inst) throws CothorityCryptoException {
        this.instId = new InstanceId(inst.getInstanceid());
        if (inst.hasSpawn()) {
            this.spawn = new Spawn(inst.getSpawn());
        }
        if (inst.hasInvoke()) {
            this.invoke = new Invoke(inst.getInvoke());
        }
        if (inst.hasDelete()) {
            this.delete = new Delete(inst.getDelete());
        }
        this.signerCounters = new ArrayList<Long>();
        this.signerCounters.addAll(inst.getSignercounterList());
        this.signatures = new ArrayList<Signature>();
        for (DarcProto.Signature sig : inst.getSignaturesList()) {
            this.signatures.add(new Signature(sig));
        }
    }

    public InstanceId getInstId() {
        return this.instId;
    }

    public void setSignerCounters(List<Long> signerCounters) {
        this.signerCounters = signerCounters;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public byte[] hash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.instId.getId());
            List<Object> args = new ArrayList();
            if (this.spawn != null) {
                digest.update((byte)0);
                digest.update(this.spawn.getContractId().getBytes());
                args = this.spawn.getArguments();
            } else if (this.invoke != null) {
                digest.update((byte)1);
                args = this.invoke.getArguments();
            } else if (this.delete != null) {
                digest.update((byte)2);
            }
            for (Argument a : args) {
                digest.update(a.getName().getBytes());
                digest.update(a.getValue());
            }
            for (Long ctr : this.signerCounters) {
                ByteBuffer buffer = ByteBuffer.allocate(8);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.putLong(ctr);
                digest.update(buffer.array());
            }
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public ByzCoinProto.Instruction toProto() {
        ByzCoinProto.Instruction.Builder b = ByzCoinProto.Instruction.newBuilder();
        b.setInstanceid(ByteString.copyFrom((byte[])this.instId.getId()));
        if (this.spawn != null) {
            b.setSpawn(this.spawn.toProto());
        } else if (this.invoke != null) {
            b.setInvoke(this.invoke.toProto());
        } else if (this.delete != null) {
            b.setDelete(this.delete.toProto());
        }
        b.addAllSignercounter(this.signerCounters);
        for (Signature s : this.signatures) {
            b.addSignatures(s.toProto());
        }
        return b.build();
    }

    public String action() {
        String a = "invalid";
        if (this.spawn != null) {
            a = "spawn:" + this.spawn.getContractId();
        } else if (this.invoke != null) {
            a = "invoke:" + this.invoke.getCommand();
        } else if (this.delete != null) {
            a = "delete";
        }
        return a;
    }

    public void signWith(byte[] ctxHash, List<Signer> signers) throws CothorityCryptoException {
        this.signatures = new ArrayList<Signature>();
        for (Signer signer : signers) {
            try {
                this.signatures.add(new Signature(signer.sign(ctxHash), signer.getIdentity()));
            }
            catch (Signer.SignRequestRejectedException e) {
                throw new CothorityCryptoException(e.getMessage());
            }
        }
    }

    public InstanceId deriveId(String what) throws CothorityCryptoException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(this.hash());
            digest.update(Instruction.intToArr4(this.signatures.size()));
            for (Signature sig : this.signatures) {
                digest.update(Instruction.intToArr4(sig.signature.length));
                digest.update(sig.signature);
            }
            digest.update(what.getBytes());
            return new InstanceId(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public Spawn getSpawn() {
        return this.spawn;
    }

    public Invoke getInvoke() {
        return this.invoke;
    }

    public Delete getDelete() {
        return this.delete;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    private static byte[] intToArr4(int x) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.LITTLE_ENDIAN);
        b.putInt(x);
        return b.array();
    }
}

