/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.byzgen;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.calypso.LTSInstance;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.network.ServerIdentity;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalypsoFactory {
    private ArrayList<ServerIdentity> servers = new ArrayList();
    private SkipblockId genesis;
    private LTSId ltsId;
    private static final Logger logger = LoggerFactory.getLogger(CalypsoFactory.class);

    public CalypsoFactory setGenesis(SkipblockId genesis) {
        this.genesis = genesis;
        return this;
    }

    public CalypsoFactory setLTSId(LTSId ltsId) {
        this.ltsId = ltsId;
        return this;
    }

    public CalypsoFactory addConode(ServerIdentity id) {
        if (!id.getAddress().getScheme().equals("tls")) {
            throw new IllegalArgumentException("conode address must be in tls:// format like \"tls://127.0.0.0:7001\"");
        }
        this.servers.add(id);
        return this;
    }

    public CalypsoFactory addConodes(List<ServerIdentity> ids) {
        for (ServerIdentity id : ids) {
            this.addConode(id);
        }
        return this;
    }

    public CalypsoRPC createConnection() throws CothorityException {
        if (null == this.genesis) {
            throw new IllegalStateException("Connection can not be established. No genesis specified.");
        }
        if (null == this.ltsId) {
            throw new IllegalStateException("Connection can not be established. No ltsId specified.");
        }
        return CalypsoRPC.fromCalypso(this.createRoster(), this.genesis, this.ltsId);
    }

    public CalypsoRPC initialiseNewCalypso(Signer admin) throws CothorityException {
        Roster roster = this.createRoster();
        Darc adminDarc = ByzCoinRPC.makeGenesisDarc(admin, roster);
        adminDarc.addIdentity("invoke:" + LTSInstance.InvokeCommand, admin.getIdentity(), " | ");
        adminDarc.addIdentity("spawn:" + LTSInstance.ContractId, admin.getIdentity(), " | ");
        ByzCoinRPC bc = new ByzCoinRPC(roster, adminDarc, Duration.ofMillis(500L));
        for (ServerIdentity si : bc.getRoster().getNodes()) {
            CalypsoRPC.authorise(si, bc.getGenesisBlock().getId());
        }
        return new CalypsoRPC(bc, adminDarc.getId(), roster, Collections.singletonList(admin), Collections.singletonList(1L));
    }

    private Roster createRoster() {
        if (this.servers.size() < 1) {
            throw new IllegalStateException("Connection can not be established. No cothority server was specified.");
        }
        return new Roster(this.servers);
    }
}

