/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.calypso.CreateLTSReply;
import ch.epfl.dedis.calypso.DecryptKeyReply;
import ch.epfl.dedis.calypso.LTSId;
import ch.epfl.dedis.calypso.LTSInstance;
import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.darc.Darc;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.network.ServerIdentity;
import ch.epfl.dedis.lib.proto.Calypso;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalypsoRPC
extends ByzCoinRPC {
    private CreateLTSReply lts;
    private final Logger logger = LoggerFactory.getLogger(CalypsoRPC.class);

    public CalypsoRPC(ByzCoinRPC byzcoin, DarcId darcId, Roster ltsRoster, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        super(byzcoin);
        CreateLTSReply lts;
        LTSInstance inst = new LTSInstance(this, darcId, ltsRoster, signers, signerCtrs);
        Proof proof = inst.getProof();
        this.lts = lts = this.createLTS(proof);
    }

    private CalypsoRPC(ByzCoinRPC bc, LTSId ltsId) throws CothorityCommunicationException, CothorityCryptoException {
        super(bc);
        this.lts = this.getLTSReply(ltsId);
    }

    private CalypsoRPC(Roster roster, Darc genesis, Duration blockInterval) throws CothorityException {
        super(roster, genesis, blockInterval);
    }

    public CreateLTSReply getLTSReply(LTSId ltsId) throws CothorityCommunicationException {
        Calypso.GetLTSReply.Builder request = Calypso.GetLTSReply.newBuilder();
        request.setLtsid(ltsId.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/GetLTSReply", request.build());
        try {
            Calypso.CreateLTSReply reply = Calypso.CreateLTSReply.parseFrom(msg);
            return new CreateLTSReply(reply);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public CreateLTSReply createLTS(Proof proof) throws CothorityCommunicationException {
        Calypso.CreateLTS.Builder b = Calypso.CreateLTS.newBuilder();
        b.setProof(proof.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/CreateLTS", b.build());
        try {
            Calypso.CreateLTSReply resp = Calypso.CreateLTSReply.parseFrom(msg);
            return new CreateLTSReply(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public void reshareLTS(Proof proof) throws CothorityCommunicationException {
        Calypso.ReshareLTS.Builder b = Calypso.ReshareLTS.newBuilder();
        b.setProof(proof.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/ReshareLTS", b.build());
        try {
            Calypso.ReshareLTSReply.parseFrom(msg);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public DecryptKeyReply tryDecrypt(Proof writeProof, Proof readProof) throws CothorityCommunicationException {
        Calypso.DecryptKey.Builder b = Calypso.DecryptKey.newBuilder();
        b.setRead(readProof.toProto());
        b.setWrite(writeProof.toProto());
        ByteString msg = this.getRoster().sendMessage("Calypso/DecryptKey", b.build());
        try {
            Calypso.DecryptKeyReply resp = Calypso.DecryptKeyReply.parseFrom(msg);
            return new DecryptKeyReply(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public LTSId getLTSId() {
        return this.lts.getLTSID();
    }

    public Point getLTSX() {
        return this.lts.getX();
    }

    public CreateLTSReply getLTS() {
        return this.lts;
    }

    public static CalypsoRPC fromCalypso(Roster roster, SkipblockId byzcoinId, LTSId ltsId) throws CothorityException {
        return new CalypsoRPC(ByzCoinRPC.fromByzCoin(roster, byzcoinId), ltsId);
    }

    public static void authorise(ServerIdentity si, SkipblockId byzcoinId) throws CothorityCommunicationException {
        Calypso.Authorise.Builder b = Calypso.Authorise.newBuilder();
        b.setByzcoinid(byzcoinId.toProto());
        Roster r = new Roster(Collections.singletonList(si));
        ByteString msg = r.sendMessage("Calypso/Authorise", b.build());
        try {
            Calypso.AuthoriseReply.parseFrom(msg);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }
}

