/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.PointFactory;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.proto.Calypso;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DecryptKeyReply {
    private List<Point> Cs;
    private Point XhatEnc;
    private Point X;

    public DecryptKeyReply(Calypso.DecryptKeyReply proto) {
        this.Cs = proto.getCsList().stream().map(cs -> PointFactory.getInstance().fromProto((ByteString)cs)).collect(Collectors.toList());
        this.XhatEnc = PointFactory.getInstance().fromProto(proto.getXhatenc());
        this.X = PointFactory.getInstance().fromProto(proto.getX());
    }

    public byte[] getKeyMaterial(Scalar reader) throws CothorityCryptoException {
        Scalar xc = reader.reduce();
        Scalar xcInv = xc.negate();
        Point XhatDec = this.X.mul(xcInv);
        Point Xhat = this.XhatEnc.add(XhatDec);
        Point XhatInv = Xhat.negate();
        byte[] keyMaterial = "".getBytes();
        for (Point C : this.Cs) {
            Point keyPointHat = C.add(XhatInv);
            byte[] keyPart = keyPointHat.data();
            int lastpos = keyMaterial.length;
            keyMaterial = Arrays.copyOfRange(keyMaterial, 0, keyMaterial.length + keyPart.length);
            System.arraycopy(keyPart, 0, keyMaterial, lastpos, keyPart.length);
        }
        return keyMaterial;
    }
}

