/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.LTSInstanceInfo;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.network.Roster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTSInstance {
    public static String ContractId = "longTermSecret";
    public static String InvokeCommand = "reshare";
    private Instance instance;
    private CalypsoRPC calypso;
    private static final Logger logger = LoggerFactory.getLogger(LTSInstance.class);

    public LTSInstance(CalypsoRPC calypso, DarcId darcID, Roster roster, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        ClientTransaction ctx = LTSInstance.createSpawnTx(new LTSInstanceInfo(roster), darcID, signers, signerCtrs);
        calypso.sendTransactionAndWait(ctx, 10);
        this.instance = LTSInstance.getInstance(calypso, ctx.getInstructions().get(0).deriveId(""));
        this.calypso = calypso;
    }

    private LTSInstance(CalypsoRPC calypso, InstanceId instanceId) throws CothorityException {
        Instance inst = LTSInstance.getInstance(calypso, instanceId);
        this.calypso = calypso;
        this.instance = inst;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static LTSInstance fromByzCoin(CalypsoRPC calypso, InstanceId id) throws CothorityException {
        return new LTSInstance(calypso, id);
    }

    public void reshareLTS(Roster roster, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        ClientTransaction ctx = LTSInstance.createInvokeTx(new LTSInstanceInfo(roster), this.instance.getId(), signers, signerCtrs);
        this.calypso.sendTransactionAndWait(ctx, 10);
    }

    public Proof getProof() throws CothorityCommunicationException {
        return this.calypso.getProof(this.instance.getId());
    }

    private static ClientTransaction createSpawnTx(LTSInstanceInfo info, DarcId darcID, List<Signer> signers, List<Long> signerCtrs) throws CothorityCryptoException {
        byte[] infoBuf = info.toProto().toByteArray();
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("lts_instance_info", infoBuf));
        Spawn sp = new Spawn(ContractId, args);
        Instruction inst = new Instruction(new InstanceId(darcID.getId()), signerCtrs, sp);
        ClientTransaction ctx = new ClientTransaction(Collections.singletonList(inst));
        ctx.signWith(signers);
        return ctx;
    }

    private static ClientTransaction createInvokeTx(LTSInstanceInfo info, InstanceId instanceId, List<Signer> signers, List<Long> signerCtrs) throws CothorityCryptoException {
        byte[] infoBuf = info.toProto().toByteArray();
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("lts_instance_info", infoBuf));
        Invoke invoke = new Invoke(InvokeCommand, args);
        Instruction inst = new Instruction(instanceId, signerCtrs, invoke);
        ClientTransaction ctx = new ClientTransaction(Collections.singletonList(inst));
        ctx.signWith(signers);
        return ctx;
    }

    private static Instance getInstance(CalypsoRPC calypso, InstanceId id) throws CothorityException {
        Instance inst = calypso.getProof(id).getInstance();
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contractId: {}", (Object)inst.getContractId());
            throw new CothorityNotFoundException("this is not an " + ContractId + " instance");
        }
        logger.info("new " + ContractId + " instance: " + inst.getId().toString());
        return inst;
    }
}

