/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.calypso.CalypsoRPC;
import ch.epfl.dedis.calypso.DecryptKeyReply;
import ch.epfl.dedis.calypso.ReadData;
import ch.epfl.dedis.calypso.WriteInstance;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadInstance {
    public static String ContractId = "calypsoRead";
    private Instance instance;
    private CalypsoRPC calypso;
    private static final Logger logger = LoggerFactory.getLogger(ReadInstance.class);

    public ReadInstance(CalypsoRPC calypso, WriteInstance write, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        this.calypso = calypso;
        ClientTransaction ctx = this.createCTX(write, signers, signerCtrs, signers.get(0).getPublic());
        calypso.sendTransactionAndWait(ctx, 10);
        this.instance = ReadInstance.getInstance(calypso, ctx.getInstructions().get(0).deriveId(""));
    }

    public ReadInstance(CalypsoRPC calypso, WriteInstance write, List<Signer> signers, List<Long> signerCtrs, Point Xc) throws CothorityException {
        this.calypso = calypso;
        ClientTransaction ctx = this.createCTX(write, signers, signerCtrs, Xc);
        calypso.sendTransactionAndWait(ctx, 10);
        this.instance = ReadInstance.getInstance(calypso, ctx.getInstructions().get(0).deriveId(""));
    }

    private ReadInstance(CalypsoRPC calypso, Instance inst) {
        this.calypso = calypso;
        this.instance = inst;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public ReadData getRead() throws CothorityNotFoundException {
        return new ReadData(this.instance);
    }

    public byte[] decryptKeyMaterial(Scalar reader) throws CothorityException {
        Proof readProof = this.calypso.getProof(this.getInstance().getId());
        Proof writeProof = this.calypso.getProof(this.getRead().getWriteId());
        DecryptKeyReply dk = this.calypso.tryDecrypt(writeProof, readProof);
        return dk.getKeyMaterial(reader);
    }

    public static ReadInstance fromByzCoin(CalypsoRPC calypso, InstanceId id) throws CothorityException {
        return new ReadInstance(calypso, ReadInstance.getInstance(calypso, id));
    }

    private ClientTransaction createCTX(WriteInstance write, List<Signer> consumers, List<Long> consumerCtrs, Point Xc) throws CothorityCryptoException {
        Instance writeInstance = write.getInstance();
        ReadData read = new ReadData(writeInstance.getId(), Xc);
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("read", read.toProto().toByteArray()));
        Spawn sp = new Spawn(ContractId, args);
        Instruction inst = new Instruction(writeInstance.getId(), consumerCtrs, sp);
        ClientTransaction ctx = new ClientTransaction(Arrays.asList(inst));
        ctx.signWith(consumers);
        return ctx;
    }

    private InstanceId read(ReadData rr, DarcId darcID, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        Argument arg = new Argument("read", rr.toProto().toByteArray());
        Spawn spawn = new Spawn(ContractId, Arrays.asList(arg));
        Instruction instr = new Instruction(new InstanceId(darcID.getId()), signerCtrs, spawn);
        ClientTransaction tx = new ClientTransaction(Arrays.asList(instr));
        tx.signWith(signers);
        this.calypso.sendTransactionAndWait(tx, 5);
        return instr.deriveId("");
    }

    private static Instance getInstance(CalypsoRPC calypso, InstanceId id) throws CothorityException {
        Instance inst = calypso.getProof(id).getInstance();
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contractId: {}", (Object)inst.getContractId());
            throw new CothorityNotFoundException("this is not an " + ContractId + " instance");
        }
        logger.info("new " + ContractId + " instance: " + inst.getId().toString());
        return inst;
    }
}

