/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.calypso;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.calypso.CreateLTSReply;
import ch.epfl.dedis.calypso.WriteInstance;
import ch.epfl.dedis.lib.crypto.Ed25519KeyPair;
import ch.epfl.dedis.lib.crypto.Ed25519Point;
import ch.epfl.dedis.lib.crypto.Ed25519Scalar;
import ch.epfl.dedis.lib.crypto.Point;
import ch.epfl.dedis.lib.crypto.Scalar;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.Calypso;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;

public class WriteData {
    private Calypso.Write write;

    public WriteData(CreateLTSReply lts, byte[] dataEnc, byte[] keyMaterial, byte[] extraData, DarcId publisher) throws CothorityException {
        if (dataEnc.length > 8000000) {
            throw new CothorityException("data length too long");
        }
        Calypso.Write.Builder wr = Calypso.Write.newBuilder();
        wr.setData(ByteString.copyFrom((byte[])dataEnc));
        if (extraData != null) {
            wr.setExtradata(ByteString.copyFrom((byte[])extraData));
        }
        wr.setLtsid(lts.getLTSID().toProto());
        this.encryptKey(wr, lts, keyMaterial, publisher);
        this.write = wr.build();
    }

    private WriteData(Calypso.Write w) {
        this.write = w;
    }

    public static WriteData fromByzcoin(ByzCoinRPC bc, InstanceId id) throws CothorityNotFoundException, CothorityCommunicationException {
        return WriteData.fromInstance(Instance.fromByzcoin(bc, id));
    }

    public static WriteData fromInstance(Instance inst) throws CothorityNotFoundException {
        if (!inst.getContractId().equals(WriteInstance.ContractId)) {
            throw new CothorityNotFoundException("Wrong contract in instance");
        }
        try {
            return new WriteData(Calypso.Write.parseFrom(inst.getData()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityNotFoundException("couldn't parse protobuffer for writeData: " + e.getMessage());
        }
    }

    private void encryptKey(Calypso.Write.Builder wr, CreateLTSReply lts, byte[] keyMaterial, DarcId darcId) throws CothorityCryptoException {
        try {
            Ed25519KeyPair randkp = new Ed25519KeyPair();
            Scalar r = randkp.scalar;
            Point U = randkp.point;
            wr.setU(U.toProto());
            Point C = lts.getX().mul(r);
            ArrayList<Point> Cs = new ArrayList<Point>();
            for (int from = 0; from < keyMaterial.length; from += 30) {
                int to = from + 30;
                if (to > keyMaterial.length) {
                    to = keyMaterial.length;
                }
                Point keyEd25519Point = Ed25519Point.embed(Arrays.copyOfRange(keyMaterial, from, to));
                Point Ckey = C.add(keyEd25519Point);
                Cs.add(Ckey);
                wr.addCs(Ckey.toProto());
            }
            Point gBar = Ed25519Point.base().mul(new Ed25519Scalar(lts.getLTSID().getId()));
            Point Ubar = gBar.mul(r);
            wr.setUbar(Ubar.toProto());
            Ed25519KeyPair skp = new Ed25519KeyPair();
            Scalar s = skp.scalar;
            Point w = skp.point;
            Point wBar = gBar.mul(s);
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            for (Point c : Cs) {
                hash.update(c.toBytes());
            }
            hash.update(U.toBytes());
            hash.update(Ubar.toBytes());
            hash.update(w.toBytes());
            hash.update(wBar.toBytes());
            hash.update(darcId.getId());
            Ed25519Scalar E = new Ed25519Scalar(hash.digest());
            wr.setE(E.toProto());
            Scalar F = s.add(E.mul(r));
            wr.setF(F.toProto());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hashing-error: " + e.getMessage());
        }
    }

    public byte[] getDataEnc() {
        return this.write.getData().toByteArray();
    }

    public byte[] getExtraData() {
        return this.write.getExtradata().toByteArray();
    }

    public Calypso.Write toProto() {
        return this.write;
    }

    public static WriteData fromProto(byte[] buf) throws InvalidProtocolBufferException {
        return new WriteData(Calypso.Write.parseFrom(buf));
    }
}

