/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.eventlog;

import ch.epfl.dedis.byzcoin.ByzCoinRPC;
import ch.epfl.dedis.byzcoin.Instance;
import ch.epfl.dedis.byzcoin.InstanceId;
import ch.epfl.dedis.byzcoin.Proof;
import ch.epfl.dedis.byzcoin.StateChangeBody;
import ch.epfl.dedis.byzcoin.transaction.Argument;
import ch.epfl.dedis.byzcoin.transaction.ClientTransaction;
import ch.epfl.dedis.byzcoin.transaction.Instruction;
import ch.epfl.dedis.byzcoin.transaction.Invoke;
import ch.epfl.dedis.byzcoin.transaction.Spawn;
import ch.epfl.dedis.eventlog.Event;
import ch.epfl.dedis.eventlog.SearchResponse;
import ch.epfl.dedis.lib.darc.DarcId;
import ch.epfl.dedis.lib.darc.Signer;
import ch.epfl.dedis.lib.exception.CothorityCommunicationException;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.exception.CothorityNotFoundException;
import ch.epfl.dedis.lib.proto.EventLogProto;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogInstance {
    public static String ContractId = "eventlog";
    private Instance instance;
    private ByzCoinRPC bc;
    private static final Logger logger = LoggerFactory.getLogger(EventLogInstance.class);

    public EventLogInstance(ByzCoinRPC bc, DarcId darcId, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        this.bc = bc;
        InstanceId id = this.initEventlogInstance(darcId, signers, signerCtrs);
        try {
            Thread.sleep(5L * bc.getConfig().getBlockInterval().toMillis());
        }
        catch (InterruptedException e) {
            throw new CothorityException(e);
        }
        this.setInstance(id);
    }

    public EventLogInstance(ByzCoinRPC bc, InstanceId id) throws CothorityException {
        this.bc = bc;
        this.setInstance(id);
    }

    public List<InstanceId> log(List<Event> events, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        Pair<ClientTransaction, List<InstanceId>> txAndKeys = this.makeTx(events, signers, signerCtrs);
        this.bc.sendTransaction((ClientTransaction)txAndKeys._1);
        return (List)txAndKeys._2;
    }

    public InstanceId log(Event event, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        return this.log(Arrays.asList(event), signers, signerCtrs).get(0);
    }

    public Event get(InstanceId key) throws CothorityException {
        Proof p = this.bc.getProof(key);
        if (!p.matches()) {
            throw new CothorityCryptoException("key does not exist");
        }
        if (!Arrays.equals(p.getKey(), key.getId())) {
            throw new CothorityCryptoException("wrong key");
        }
        StateChangeBody body = p.getValues();
        try {
            EventLogProto.Event event = EventLogProto.Event.parseFrom(body.getValue());
            return new Event(event);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public SearchResponse search(String topic, long from, long to) throws CothorityException {
        EventLogProto.SearchRequest.Builder b = EventLogProto.SearchRequest.newBuilder();
        b.setInstance(ByteString.copyFrom((byte[])this.instance.getId().getId()));
        b.setId(this.bc.getGenesisBlock().getId().toProto());
        b.setTopic(topic);
        b.setFrom(from);
        b.setTo(to);
        ByteString msg = this.bc.getRoster().sendMessage("EventLog/SearchRequest", b.build());
        try {
            EventLogProto.SearchResponse resp = EventLogProto.SearchResponse.parseFrom(msg);
            return new SearchResponse(resp);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityCommunicationException(e);
        }
    }

    public InstanceId getInstanceId() {
        return this.instance.getId();
    }

    public static EventLogInstance fromByzcoin(ByzCoinRPC bc, InstanceId id) throws CothorityException {
        return new EventLogInstance(bc, id);
    }

    private InstanceId initEventlogInstance(DarcId darcId, List<Signer> signers, List<Long> signerCtrs) throws CothorityException {
        if (this.instance != null) {
            throw new CothorityException("already have a contract");
        }
        Spawn spawn = new Spawn(ContractId, new ArrayList<Argument>());
        Instruction instr = new Instruction(new InstanceId(darcId.getId()), signerCtrs, spawn);
        ClientTransaction tx = new ClientTransaction(Arrays.asList(instr));
        tx.signWith(signers);
        this.bc.sendTransaction(tx);
        return instr.deriveId("");
    }

    private void setInstance(InstanceId id) throws CothorityException {
        Instance inst = Instance.fromByzcoin(this.bc, id);
        if (!inst.getContractId().equals(ContractId)) {
            logger.error("wrong contract: {}", (Object)inst.getContractId());
            throw new CothorityNotFoundException("this is not an eventlog contract");
        }
        this.instance = inst;
        logger.info("new eventlog contract: " + inst.getId().toString());
    }

    private Pair<ClientTransaction, List<InstanceId>> makeTx(List<Event> events, List<Signer> signers, List<Long> signerCtrs) throws CothorityCryptoException {
        ArrayList<Instruction> instrs = new ArrayList<Instruction>();
        ArrayList<InstanceId> keys = new ArrayList<InstanceId>();
        for (Event e : events) {
            ArrayList<Argument> args = new ArrayList<Argument>();
            args.add(new Argument("event", e.toProto().toByteArray()));
            Invoke invoke = new Invoke(ContractId, args);
            Instruction instr = new Instruction(this.instance.getId(), new ArrayList<Long>(signerCtrs), invoke);
            instrs.add(instr);
            signerCtrs = EventLogInstance.incrementCtrs(signerCtrs);
        }
        ClientTransaction tx = new ClientTransaction(instrs);
        tx.signWith(signers);
        for (Instruction instr : tx.getInstructions()) {
            keys.add(instr.deriveId(""));
        }
        return new Pair<ClientTransaction, List<InstanceId>>(tx, keys);
    }

    private static List<Long> incrementCtrs(List<Long> xs) {
        ArrayList<Long> out = new ArrayList<Long>(xs);
        for (int i = 0; i < out.size(); ++i) {
            out.set(i, (Long)out.get(i) + 1L);
        }
        return out;
    }

    private static final class Pair<A, B> {
        A _1;
        B _2;

        private Pair(A a, B b) {
            this._1 = a;
            this._2 = b;
        }
    }
}

