/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.dedis.lib;

import ch.epfl.dedis.lib.SkipblockId;
import ch.epfl.dedis.lib.exception.CothorityCryptoException;
import ch.epfl.dedis.lib.exception.CothorityException;
import ch.epfl.dedis.lib.network.Roster;
import ch.epfl.dedis.lib.proto.SkipchainProto;
import ch.epfl.dedis.skipchain.ForwardLink;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class SkipBlock {
    private SkipchainProto.SkipBlock skipBlock;

    public SkipBlock(SkipchainProto.SkipBlock skipBlock) {
        this.skipBlock = skipBlock;
    }

    public SkipBlock(byte[] sb) throws CothorityException {
        try {
            this.skipBlock = SkipchainProto.SkipBlock.parseFrom(sb);
        }
        catch (InvalidProtocolBufferException e) {
            throw new CothorityException(e);
        }
    }

    public byte[] getHash() {
        return this.skipBlock.getHash().toByteArray();
    }

    public SkipblockId getId() {
        return new SkipblockId(this.getHash());
    }

    public SkipblockId getSkipchainId() throws CothorityCryptoException {
        if (this.skipBlock.getIndex() == 0) {
            return this.getId();
        }
        return new SkipblockId(this.skipBlock.getGenesis().toByteArray());
    }

    public byte[] getData() {
        return this.skipBlock.getData().toByteArray();
    }

    public byte[] getPayload() {
        return this.skipBlock.getPayload().toByteArray();
    }

    public int getIndex() {
        return this.skipBlock.getIndex();
    }

    public List<ForwardLink> getForwardLinks() {
        ArrayList<ForwardLink> ret = new ArrayList<ForwardLink>();
        this.skipBlock.getForwardList().forEach(fl -> ret.add(new ForwardLink((SkipchainProto.ForwardLink)fl)));
        return ret;
    }

    public Roster getRoster() throws CothorityException {
        try {
            return new Roster(this.skipBlock.getRoster());
        }
        catch (URISyntaxException e) {
            throw new CothorityException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SkipBlock)) {
            return super.equals(obj);
        }
        SkipBlock other = (SkipBlock)obj;
        return other.getId().equals(this.getId());
    }

    public byte[] toByteArray() {
        return this.skipBlock.toByteArray();
    }

    public SkipchainProto.SkipBlock getProto() {
        return this.skipBlock;
    }
}

